package jp.sourceforge.sos.gunmetry.marker;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.lib.color.JCanvasColor;
import jp.sourceforge.sos.lib.design.observer.IObserver;

@SuppressWarnings("serial")
class ViewPanel extends JPanel implements IPresentation, IObserver<Boolean> {

	private JToggleButton	jToggleButton		= null;

	private JToggleButton	jToggleButton1		= null;

	private JSpinner		jSpinner			= null;

	private JCanvasColor	jCanvasColorObj		= null;

	private JCanvasColor	jCanvasColorBack	= null;

	private JLabel			jLabel5				= null;

	private JLabel			jLabel				= null;

	private JLabel			jLabel1				= null;

	protected ModelMarker	modelMarker;

	private JLabel			jLabelNBack			= null;

	private JLabel			jLabelNObj			= null;

	ViewPanel() {
		super();
		initialize();
		
		Mediator.<Boolean>add(Mediator.Subjects.READY_TO_ANALYSIS,this);
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
		gridBagConstraints22.gridx = 2;
		gridBagConstraints22.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints22.gridy = 2;
		GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
		gridBagConstraints13.gridx = 2;
		gridBagConstraints13.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints13.gridy = 4;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.gridx = 1;
		gridBagConstraints3.insets = new java.awt.Insets(0, 10, 0, 0);
		gridBagConstraints3.gridy = 4;
		jLabel1 = new JLabel();
		jLabel1.setText("n =");

		GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
		gridBagConstraints21.gridx = 1;
		gridBagConstraints21.insets = new java.awt.Insets(0, 10, 0, 0);
		gridBagConstraints21.gridy = 2;
		jLabel = new JLabel();
		jLabel.setText("n =");

		GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
		gridBagConstraints12.gridx = 0;
		gridBagConstraints12.gridy = 0;
		jLabel5 = new JLabel();
		jLabel5.setText("size: ");

		GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
		gridBagConstraints11.gridheight = 1;
		gridBagConstraints11.gridx = 1;
		gridBagConstraints11.gridy = 3;
		gridBagConstraints11.ipadx = 0;
		gridBagConstraints11.ipady = 0;
		gridBagConstraints11.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints11.insets = new java.awt.Insets(2, 5, 0, 0);
		gridBagConstraints11.gridwidth = 2;
		GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
		gridBagConstraints10.gridheight = 1;
		gridBagConstraints10.gridx = 1;
		gridBagConstraints10.gridy = 1;
		gridBagConstraints10.ipadx = 0;
		gridBagConstraints10.ipady = 0;
		gridBagConstraints10.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints10.insets = new java.awt.Insets(2, 5, 0, 0);
		gridBagConstraints10.gridwidth = 2;
		GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
		gridBagConstraints9.gridheight = 1;
		gridBagConstraints9.gridx = 1;
		gridBagConstraints9.gridy = 0;
		gridBagConstraints9.ipadx = 0;
		gridBagConstraints9.ipady = 0;
		gridBagConstraints9.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints9.gridwidth = 2;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.gridheight = 2;
		gridBagConstraints4.gridx = 0;
		gridBagConstraints4.gridy = 3;
		gridBagConstraints4.ipadx = 0;
		gridBagConstraints4.ipady = 0;
		gridBagConstraints4.gridwidth = 1;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.gridheight = 2;
		gridBagConstraints2.gridx = 0;
		gridBagConstraints2.gridy = 1;
		gridBagConstraints2.ipadx = 0;
		gridBagConstraints2.ipady = 0;
		gridBagConstraints2.gridwidth = 1;
		this.setLayout(new GridBagLayout());
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "MarkerSet", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
				javax.swing.border.TitledBorder.DEFAULT_POSITION, null, null));
		this.add(jLabel5, gridBagConstraints12);
		this.add(getJSpinner(), gridBagConstraints9);
		this.add(getJToggleButton(), gridBagConstraints2);
		this.add(getJCanvasColorObj(), gridBagConstraints10);
		this.add(jLabel, gridBagConstraints21);
		this.add(getJToggleButton1(), gridBagConstraints4);
		this.add(getJCanvasColorBack(), gridBagConstraints11);
		this.add(jLabel1, gridBagConstraints3);
		this.add(getJLabelNBack(), gridBagConstraints13);
		this.add(getJLabelNObj(), gridBagConstraints22);
	}

	public void setAbstraction(IAbstraction abstraction) {
		modelMarker = (ModelMarker)abstraction;

		jCanvasColorObj.setModel(modelMarker.getObjColorModel());
		jCanvasColorBack.setModel(modelMarker.getBackColorModel());
		
		jSpinner.setValue(5);
	}

	/**
	 * This method initializes jToggleButton
	 * 
	 * @return javax.swing.JToggleButton
	 */
	private JToggleButton getJToggleButton() {
		if (jToggleButton==null) {
			jToggleButton = new JToggleButton();
			jToggleButton.setIcon(new ImageIcon(getClass().getResource("/jp/sourceforge/sos/gunmetry/resources/mkBtn1.gif")));
			jToggleButton.setSelected(true);
			jToggleButton.setMargin(new Insets(1, 1, 1, 1));
			jToggleButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelMarker.repaint();
				}
			});
		}
		return jToggleButton;
	}

	/**
	 * This method initializes jToggleButton1
	 * 
	 * @return javax.swing.JToggleButton
	 */
	private JToggleButton getJToggleButton1() {
		if (jToggleButton1==null) {
			jToggleButton1 = new JToggleButton();
			jToggleButton1.setIcon(new ImageIcon(getClass().getResource("/jp/sourceforge/sos/gunmetry/resources/mkBtn2.gif")));
			jToggleButton1.setSelected(true);
			jToggleButton1.setMargin(new Insets(1, 1, 1, 1));
			jToggleButton1.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelMarker.repaint();
				}
			});
		}
		return jToggleButton1;
	}

	/**
	 * This method initializes jSpinner
	 * 
	 * @return javax.swing.JSpinner
	 */
	private JSpinner getJSpinner() {
		if (jSpinner==null) {
			jSpinner = new JSpinner();
			jSpinner.setRequestFocusEnabled(false);
			jSpinner.setVerifyInputWhenFocusTarget(false);
			jSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					int value = (Integer)jSpinner.getValue();
					modelMarker.setPointRectSize(value);
				}
			});
		}
		return jSpinner;
	}

	/**
	 * This method initializes jCanvasColor
	 * 
	 * @return jp.sourceforge.sos.lib.color.JCanvasColor
	 */
	private JCanvasColor getJCanvasColorObj() {
		if (jCanvasColorObj==null) {
			jCanvasColorObj = new JCanvasColor();
			jCanvasColorObj.addMouseListener(new java.awt.event.MouseAdapter() {
				public void mousePressed(java.awt.event.MouseEvent e) {
					modelMarker.setObjectColor(jCanvasColorObj.getColor());
				}
			});
		}
		return jCanvasColorObj;
	}

	/**
	 * This method initializes jCanvasColor1
	 * 
	 * @return jp.sourceforge.sos.lib.color.JCanvasColor
	 */
	private JCanvasColor getJCanvasColorBack() {
		if (jCanvasColorBack==null) {
			jCanvasColorBack = new JCanvasColor();
			jCanvasColorBack.addMouseListener(new java.awt.event.MouseAdapter() {
				public void mousePressed(java.awt.event.MouseEvent e) {
					modelMarker.setBackgroundColor(jCanvasColorBack.getColor());
				}
			});
		}
		return jCanvasColorBack;
	}

	/**
	 * This method initializes jLabelNumberBack
	 * 
	 * @return javax.swing.JLabel
	 */
	private JLabel getJLabelNBack() {
		if (jLabelNBack==null) {
			jLabelNBack = new JLabel();
			jLabelNBack.setText("0");
			jLabelNBack.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		}
		return jLabelNBack;
	}

	/**
	 * This method initializes jLabelNuObj
	 * 
	 * @return javax.swing.JLabel
	 */
	private JLabel getJLabelNObj() {
		if (jLabelNObj==null) {
			jLabelNObj = new JLabel();
			jLabelNObj.setText("0");
			jLabelNObj.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
			jLabelNObj.setHorizontalTextPosition(javax.swing.SwingConstants.TRAILING);
		}
		return jLabelNObj;
	}

	public void update(Boolean obj) {
		jLabelNObj.setText(Integer.toString(modelMarker.getObjectNumber()));
		jLabelNBack.setText(Integer.toString(modelMarker.getBackgroundNumber()));		
	}

} // @jve:decl-index=0:visual-constraint="10,10"
