package jp.sourceforge.sos.gunmetry.mask;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.lib.color.JCanvasColor;
import jp.sourceforge.sos.lib.design.observer.IObserver;

@SuppressWarnings("serial")
class ViewPanel extends JPanel implements IPresentation, IObserver<Image> {

	private JCheckBox		jCheckBox		= null;

	private JCanvasColor	jCanvasColor	= null;

	protected ModelMask		modelMask;

	private JButton			jButton			= null;

	public ViewPanel() {
		super();
		initialize();

		Mediator.<Image>add(Mediator.Subjects.LOAD, this);
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.gridx = 1;
		gridBagConstraints2.gridy = 0;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridwidth = 2;
		gridBagConstraints1.insets = new java.awt.Insets(0, 10, 0, 0);
		gridBagConstraints1.gridy = 1;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Mask", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
				javax.swing.border.TitledBorder.DEFAULT_POSITION, null, null));
		this.add(getJCheckBox(), gridBagConstraints);
		this.add(getJCanvasColor(), gridBagConstraints1);
		this.add(getJButton(), gridBagConstraints2);

	}

	/**
	 * This method initializes jCheckBox
	 * 
	 * @return javax.swing.JCheckBox
	 */
	private JCheckBox getJCheckBox() {
		if (jCheckBox==null) {
			jCheckBox = new JCheckBox();
			jCheckBox.setText("use");
			jCheckBox.setEnabled(false);
			jCheckBox.setPreferredSize(new java.awt.Dimension(75, 24));
			jCheckBox.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelMask.setMask(jCheckBox.isSelected());
				}
			});
			jCheckBox.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					jCanvasColor.setEnabled(jCheckBox.isSelected());
				}
			});
		}
		return jCheckBox;
	}

	/**
	 * This method initializes jCanvasColor
	 * 
	 * @return jp.sourceforge.sos.lib.color.JCanvasColor
	 */
	private JCanvasColor getJCanvasColor() {
		if (jCanvasColor==null) {
			jCanvasColor = new JCanvasColor();
			jCanvasColor.setEnabled(false);
			jCanvasColor.addMouseListener(new java.awt.event.MouseAdapter() {
				public void mousePressed(java.awt.event.MouseEvent e) {
					modelMask.createMaskImage();
					modelMask.repaint();
				}
			});
		}
		return jCanvasColor;
	}

	public void setAbstraction(IAbstraction abstraction) {
		modelMask = (ModelMask)abstraction;
		jCanvasColor.setModel(modelMask.getColorModel());
	}

	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton() {
		if (jButton==null) {
			jButton = new JButton();
			jButton.setText("Load");
			jButton.setEnabled(false);
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					boolean value = modelMask.createMask();
					modelMask.setMask(value);
					jCheckBox.setEnabled(value);
					jCheckBox.setSelected(value);
				}
			});
		}
		return jButton;
	}

	public void update(Image obj) {
		boolean b = (obj!=null);
		jButton.setEnabled(b);
		if (!b) {
			jCheckBox.setEnabled(b);
		}
	}

} // @jve:decl-index=0:visual-constraint="10,10"
