; SOS Java launcher version 1.0 (May 8th, 2005)
;
; SOS java launcher is inspired by Jelude (http://www.sfu.ca/~tyuen/jelude/).
; And SOS java luncher uses Slice function written by Afrow UK (http://nsis.sourceforge.net/archive/nsisweb.php?page=678&instances=0,11,122).


;--------- CONFIGURATION ---------

; Change "-Xms256m -Xmx256m" if you want other JAVA command options.
!define DEFAULTOPTION "-Xms256m -Xmx256m"

; Uncomment the next line to specify an icon for the EXE.
;Icon "test.ico"

;---------------------------------

Name "SOS Java Launcher"
Caption "SOS Java Launcher"
OutFile "launcher.exe"

SilentInstall silent

Section ""
  
    ; get the absolute path of exe to $R0
    System::Call "kernel32::GetModuleFileNameA(i 0, t.R0, i 1024) i r1"

    ; remove directory part from $R0
    Push $EXEDIR
    Push $R0
    Call Slice
    Pop $R0
  
    ; remove separator
    Push "\"
    Push $R0
    Call Slice
    Pop $R0

    ; remove ".exe" (get BASENAME)
    Push ".exe"
    Push $R0
    Call Slice
    Pop $8 ; $8 will be BASENAME
    StrCpy $9 "$8.jar" ; $9 will be JARFILE

    ; Comment out the next line not to use cfg file
    Call GetJVM
  
    StrCpy $R1 ""
    Call GetParameters

    SetOutPath $EXEDIR
    StrCpy $R0 "$R0 $R1 -jar $9"
    Exec "$R0"

    Quit

SectionEnd

Function Slice
    Exch $R0 ; input string
    Exch
    Exch $R1 ; to cut
    Push $R2
    Push $R3
    Push $R4
    Push $R5

    StrLen $R3 $R1
    StrCpy $R4 -1
    StrCpy $R5 0

    Loop:

        IntOp $R4 $R4 + 1
        StrCpy $R2 $R0 $R3 $R4
        StrCmp $R2 "" Done
        StrCmp $R2 $R1 0 Loop

        StrCpy $R5 1

        StrCmp $R4 0 0 +3
        StrCpy $R1 ""
        Goto +2
        StrCpy $R1 $R0 $R4
        StrLen $R2 $R0
        IntOp $R4 $R2 - $R4
        IntOp $R4 $R4 - $R3
        IntCmp $R4 0 0 0 +3
        StrCpy $R2 ""
        Goto +2
        StrCpy $R2 $R0 "" -$R4
        StrCpy $R0 $R1$R2

    Done:
        StrCpy $R1 $R5

        Pop $R5
        Pop $R4
        Pop $R3
        Pop $R2
        Exch $R1 ; slice? 0/1
        Exch
        Exch $R0 ; output string
FunctionEnd

Function GetJVM

    ClearErrors
    ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" "CurrentVersion"
    ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment\$R0" "JavaHome"
    IfErrors 0 FoundVM

    ClearErrors
    ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Development Kit" "CurrentVersion"
    ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Development Kit\$R0" "JavaHome"
    IfErrors 0 FoundVM

    ClearErrors
    ReadEnvStr $R0 "JAVA_HOME"
    IfErrors NotFound 0

    FoundVM:
    StrCpy $R0 "$R0\bin\java.exe"
    IfFileExists $R0 0 NotFound
    Return

    NotFound:
    Sleep 800
    MessageBox MB_ICONEXCLAMATION|MB_YESNO \
                    'Could not find a Java Runtime Environment installed on your computer. \
                     $\nWithout it you cannot run "$9". \
                     $\n$\nWould you like to visit the Java website to download it?' \
                    IDNO +2
    ExecShell open "http://java.sun.com/"
    Quit
FunctionEnd

Function GetParameters

    StrCpy $R2 "$8.cfg"

    IfFileExists $R2 +2 0
    Call CreateCfg

    ClearErrors
    FileOpen $0 $R2 r
    IfErrors done
  
    FileRead $0 $R1
    FileClose $0 
    Return
  
    done:
    Sleep 800
    MessageBox MB_OK "Error occured on opening $R2 file."
    Quit
FunctionEnd

Function CreateCfg

    ClearErrors
    FileOpen $0 $R2 w
    IfErrors done
    FileWrite $0 "${DEFAULTOPTION}"
    FileClose $0
    Return

    done:
    Sleep 800
    MessageBox MB_OK "Error occured on creating $R2 file."
    Quit
FunctionEnd