/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>
//#include <stdio.h>
//#include <stdlib.h>
#include <glib.h>
#include <time.h>

#include "interface.h"
#include "support.h"
#include "display.h"
#include "filecntl.h"
#include "main.h"
#include "utils.h"


/* Timeout Callback */
static gboolean
reload_timeout (gpointer data)
{
  GtkWidget *window = (GtkWidget *) data;
  time_t ltime;
  struct tm *today;
  gint wyear, wmon, wday, whour, wmin, wsec;
  gint esec;
  sotsuval SV;
  char tmp[100];

  ltime = time (NULL);					// Retrieve local time
  today = localtime (&ltime);	//
//  g_print ("*");

	//Today's date
  wyear = today->tm_year;
  wmon = today->tm_mon;
  wday = today->tm_mday;
  whour = today->tm_hour;
  wmin = today->tm_min;
  wsec = today->tm_sec;
	//ParamDate
  today->tm_year = myParam.DYear - 1900;
  today->tm_mon = myParam.DMonth - 1;
  today->tm_mday = myParam.DDay;
  today->tm_hour = myParam.DHour;
  today->tm_min = myParam.DMin;
  time_t ptime = mktime (today);
  esec = difftime (ltime, ptime);
	gint r = CalSotsuVal (&SV, esec, wyear, wmon, wday, whour, wmin, wsec);
  if (r != 0) {
		g_print ("CalSotsuVal Error!! RCD=%d", r);
		//return FALSE;
	}
//  g_print ("時間差：%d秒(%d日)", esec, SV.eDay);

  GtkWidget *ElapsedTime = lookup_widget (window, "entryElapsedTime");
  GtkWidget *Status = lookup_widget (window, "entryStatus");
  GtkWidget *LifeSpan = lookup_widget (window, "entryLifeSpan");
  GtkWidget *SavedMoney = lookup_widget (window, "entrySavedMoney");
  GtkWidget *CountNotSmoked = lookup_widget (window, "entryCountNotSmoked");
  GtkWidget *TodaysComment = lookup_widget (window, "entryTodaysComment");

  sprintf (tmp, DisplayElaspedTime (SV));
  gtk_entry_set_text (GTK_ENTRY (ElapsedTime), _(tmp));
  sprintf (tmp, "    %s", DisplayStatus (SV.eDay));
  gtk_entry_set_text (GTK_ENTRY (Status), _(tmp));
  sprintf (tmp, DisplayLifeSpan (SV));
  gtk_entry_set_text (GTK_ENTRY (LifeSpan), _(tmp));
  sprintf (tmp, DisplaySavedMoney (SV));
  gtk_entry_set_text (GTK_ENTRY (SavedMoney), _(tmp));
  sprintf (tmp, DisplayCountNotSmoked (SV));
  gtk_entry_set_text (GTK_ENTRY (CountNotSmoked), _(tmp));
  gtk_entry_set_text (GTK_ENTRY (TodaysComment), DisplayTodaysComment (SV));

  /* Change images */
  /* ProgressBar */
  DisplayVariousImages (window, SV);

  /* Change color: ElaspedTime, Status, LifeSpan, SavedMoney, CountNotSmoked, TodaysComment */
  gtk_widget_modify_text (ElapsedTime, GTK_STATE_NORMAL, &myParam.colorText);
  gtk_widget_modify_base (ElapsedTime, GTK_STATE_NORMAL, &myParam.colorBG);
  gtk_widget_modify_text (Status, GTK_STATE_NORMAL, &myParam.colorText);
  gtk_widget_modify_base (Status, GTK_STATE_NORMAL, &myParam.colorBG);
  gtk_widget_modify_text (LifeSpan, GTK_STATE_NORMAL, &myParam.colorText);
  gtk_widget_modify_base (LifeSpan, GTK_STATE_NORMAL, &myParam.colorBG);
  gtk_widget_modify_text (SavedMoney, GTK_STATE_NORMAL, &myParam.colorText);
  gtk_widget_modify_base (SavedMoney, GTK_STATE_NORMAL, &myParam.colorBG);
  gtk_widget_modify_text (CountNotSmoked, GTK_STATE_NORMAL,
			  &myParam.colorText);
  gtk_widget_modify_base (CountNotSmoked, GTK_STATE_NORMAL, &myParam.colorBG);
  gtk_widget_modify_text (TodaysComment, GTK_STATE_NORMAL,
			  &myParam.colorText);
  gtk_widget_modify_base (TodaysComment, GTK_STATE_NORMAL, &myParam.colorBG);

  /* (timeout callback) TRUE continues callback, FALSE exits */
  return TRUE;
}

/* Timeout Callback */
static gboolean
reload_timeout_mini (gpointer data)
{
	GtkWidget *window = (GtkWidget *)data;
  GtkWidget *labelDisplayMini = lookup_widget (window, "labelDisplayMini");

	const gchar *cbStatus = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window1, "entryStatus")));
	const gchar *cbElapsedTime = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window1, "entryElapsedTime")));
	const gchar *cbLifeSpan = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window1, "entryLifeSpan")));
	const gchar *cbSavedMoney = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window1, "entrySavedMoney")));
	const gchar *cbCountNotSmoked = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window1, "entryCountNotSmoked")));
	//const gchar *cbTodaysComment = gtk_entry_get_text (GTK_ENTRY (lookup_widget (window, "entryTodaysComment")));
	gchar scb[400], tmp[100], tmp2[50];
	sprintf (tmp2, "%s", cbStatus);
	sprintf (tmp, "ステータス： %s\n", trim (tmp2));
	//sprintf (tmp, "ステータス： %s\n", cbStatus);
	strcpy (scb, tmp);
	if (myParam.Dcopy == 1)
		sprintf (tmp, "卒煙日： %d年 %d月 %d日\n", myParam.DYear, myParam.DMonth, myParam.DDay);
	if (myParam.Dcopy == 2)
		sprintf (tmp, "卒煙日： %d年 %d月 %d日（%d本-%d年）\n", myParam.DYear, myParam.DMonth, myParam.DDay, myParam.TCount, myParam.DSY);
/*
	if (myParam.Dcopy == 2 && myParam.DBC == FALSE)
		sprintf (tmp, "卒煙日： %d年 %d月 %d日（%d年）\n", myParam.DYear, myParam.DMonth, myParam.DDay, myParam.DSY);
	if (myParam.Dcopy == 2 && myParam.DBC == TRUE)
		sprintf (tmp, "卒煙日： %d年 %d月 %d日（%d本-%d年）\n", myParam.DYear, myParam.DMonth, myParam.DDay, myParam.TCount, myParam.DSY);
*/
	strcat (scb, tmp);
	sprintf (tmp, "卒煙からの日数：%s\n", cbElapsedTime);
	strcat (scb, tmp);
	sprintf (tmp, "延びた寿命：%s\n", cbLifeSpan);
	strcat (scb, tmp);
	sprintf (tmp, "節約できた金額：%s\n", cbSavedMoney);
	strcat (scb, tmp);
	sprintf (tmp, "節煙本数：%s\n", cbCountNotSmoked);
	strcat (scb, tmp);
	
  gtk_label_set_text (GTK_LABEL (labelDisplayMini), scb);
//  gtk_widget_modify_text (labelDisplayMini, GTK_STATE_NORMAL, &myParam.colorText);
//  gtk_widget_modify_base (labelDisplayMini, GTK_STATE_NORMAL, &myParam.colorBG);

  /* (timeout callback) TRUE continues callback, FALSE exits */
  return TRUE;
}


void
reload_timeout_from_callbacks (void)
{
	if (wMode == 0) {
			reload_timeout (window1);
	} else {
			reload_timeout_mini (window2);
	}	
}

void
sotsu_initialize (void)
{
	int ret = sotsu_file_load ();
	if(ret == 1) {
      g_print ("初期値をパラメタに入れます。\n");
      time_t ltime;
      struct tm *today;

      ltime = time (NULL);
      today = localtime (&ltime);

      sprintf (myParam.BlogUrl, "sotsuen.jpn.org/");
      myParam.Status = 2;
      gdk_color_parse ("black", &myParam.colorText);
      gdk_color_parse ("white", &myParam.colorBG);
      myParam.Dcopy = 0;
      myParam.DSY = 0;
      myParam.DBC = FALSE;
      myParam.DYear = today->tm_year + 1900;
      myParam.DMonth = today->tm_mon + 1;
      myParam.DDay = today->tm_mday;
      myParam.DHour = today->tm_hour;
      myParam.DMin = today->tm_min;
      myParam.TCount = 0;
      myParam.TPrice = 0;
      myParam.TTax = 8744;
      myParam.TTaxPer = 5;
      myParam.TSize = 2;
			//08.05.18 add
			myParam.DET = 0;
			myParam.reserved1 = 0;
			myParam.reserved2 = 0;
			myParam.reserved3 = 0;
	}		
}


void
sotsu_destroy (void)
{
	g_source_remove (timer1);
	g_source_remove (timer2);
//	gtk_widget_destroy (window1);
//	gtk_widget_destroy (window2);
	gtk_main_quit ();
}


//08.06.01 add
void tray_icon_on_click(GtkStatusIcon *status_icon, 
                        gpointer user_data)
{
				static gboolean TT_SW = TRUE;
				GtkWidget *window;
				if (wMode == 0) {
					window = window1;
				} else {
					window = window2;
				}
//        printf("Clicked on tray icon TT_SW=%d\n", TT_SW);
				if (TT_SW == TRUE) {
					TT_SW = FALSE;
					gtk_window_get_position (GTK_WINDOW (window), &w_px, &w_py); // 08.06.13 add
					gtk_widget_hide( window );
				} else {
					TT_SW = TRUE;
					gtk_window_move (GTK_WINDOW (window), w_px, w_py); // 08.06.13 add
					gtk_widget_show( window );

				}
//        printf("Now TT_SW contains value=%d\n", TT_SW);

}

//08.06.01 add
void tray_icon_on_menu(GtkStatusIcon *status_icon, guint button, 
                       guint activate_time, gpointer user_data)
{
				GtkWidget *p_menu;
				p_menu = create_menu1 ();
//				p_menu = create_menu1 (user_data);
				gtk_menu_popup(GTK_MENU (p_menu), NULL, NULL, NULL, NULL, 1, 0);
//        printf("Popup menu\n");
}

//08.06.01 add
static GtkStatusIcon *create_tray_icon(gpointer user_data) {
        GtkStatusIcon *tray_icon;

        tray_icon = gtk_status_icon_new();
        g_signal_connect(G_OBJECT(tray_icon), "activate", 
                         G_CALLBACK(tray_icon_on_click), user_data);
        g_signal_connect(G_OBJECT(tray_icon), 
                         "popup-menu",
                         G_CALLBACK(tray_icon_on_menu), NULL);
//                         G_CALLBACK(tray_icon_on_menu), user_data);
        gtk_status_icon_set_from_pixbuf (tray_icon, 
                                           create_pixbuf ("sotsuen-logo.gif"));
//        gtk_status_icon_set_from_icon_name(tray_icon, 
//                                           GTK_STOCK_MEDIA_STOP);
        gtk_status_icon_set_tooltip(tray_icon, 
                                    "卒煙式 for Linux");
        gtk_status_icon_set_visible(tray_icon, TRUE);

        return tray_icon;
}


int
main (int argc, char *argv[])
{
  //GtkWidget *window1;
  GtkStatusIcon *tray_icon;	//08.06.01 add
	
#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
//      add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
//      g_print (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  sotsu_initialize ();

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  window1 = create_window1 ();
	reload_timeout ((gpointer) window1);

	window2 = create_window2 ();
	reload_timeout_mini ((gpointer) window2);

	gtk_widget_show (window1);

	/* Interval 30 minutes */
  timer1 = g_timeout_add (30000, (GSourceFunc) reload_timeout,
			  (gpointer) window1);
 	timer2 = g_timeout_add (30000, (GSourceFunc) reload_timeout_mini,
			  (gpointer) window2);

  tray_icon = create_tray_icon(window1);	//08.06.01 add

	gtk_main ();

  return 0;
}
