/*
 * Copyright (c) 2008 TAKAHASHI Tomoyuki. All rights reserved.
 */
package jp.sourceforge.sowba.dtd2java;

/**
 * dtd2javaŎg[eBeBIuWFNgłB<br/>
 * Velocityg܂BVelocityev[gł́A$utilŃANZX\łB<br/>
 *
 * @author TAKAHASHI Tomoyuki
 *
 * <table border="1" cellpadding="3" cellspacing="0">
 * <tr bgcolor="#ccccff"><th>Ver.</th><th>t</th><th>ڍ</th></tr>
 * <tr><td>0.01</td><td>2008/01/05</td><td>VK쐬</td>
 * </table>
 */
public class Dtd2JavaUtil {

    private Recipe m_recipe;

    /**
     * RXgN^łB<br/>
     *
     * @param recipe    VsIuWFNg
     */
    public Dtd2JavaUtil(Recipe recipe) {
        super();
        m_recipe = recipe;
    }

    /**
     * w肵̐擪1啶ɂԂ܂B<br/>
     *
     * @param s 
     * @return  擪1啶ɂ
     */
    public String capitalize(String s) {
        if (s == null) return "";
        if (s.length() == 0) return "";
        if (s.length() == 1) return s.toUpperCase();

        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    /**
     * NXƂȂ镶擾܂B<br>
     * f~^(nCtAA_[XRAAR)ŋ؂̂ꂼ擪啶ɂŘAɂȂ܂B<br>
     * <ol>
     * <li>abc  Abc</li>
     * <li>ns:abc  NsAbc</li>
     * </ol>
     *
     * @param s 
     * @return  NXƂȂ镶
     */
    public String getClassName(String s) {
        String[] names = s.split("[\\-_:]");
        StringBuffer buf = new StringBuffer();
        buf.append(m_recipe.getClassPrefix());
        for (int j = 0; j < names.length; j++) {
            buf.append(capitalize(names[j]));
        }
        buf.append(m_recipe.getClassSuffix());
        String classname = new String(buf);
        return classname;
    }

    /**
     * tB[h擾܂B<br/>
     * f~^(nCtAA_[XRAAR)ŋ؂̍ŏ̗vfȊO̐擪啶ɂŘAɂȂ܂B<br>
     *
     * @param s 
     * @return  tB[hƂȂ镶
     */
    public String getFieldName(String s) {
        if (m_recipe.getReplacingAttributeMap().containsKey(s)) {
            return (String)m_recipe.getReplacingAttributeMap().get(s);
        }
        String[] names = s.split("[\\-_:]");
        StringBuffer buf = new StringBuffer();
        buf.append(names[0]);
        for (int j = 1; j < names.length; j++) {
            buf.append(capitalize(names[j]));
        }
        String fieldname = new String(buf);
        return fieldname;
    }

}
