/*
 * Copyright (c) 2008 TAKAHASHI Tomoyuki. All rights reserved.
 */
package jp.sourceforge.sowba.velocity.support;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

/**
 * Velocitỹt@C\[X[_[NX<code>org.apache.velocity.runtime.resource.loader.FileResourceLoader</code>gAVelocityev[gt@C̍s#܂ł̃Xy[XA^u܂B<br/>
 * VelocitỹvpeB́Aȉ̂悤ɐݒ肵ĂB<br/>
 * <code>resource.loader=FILE</code><br/>
 * <code>FILE.resource.loader.class=jp.sourceforge.sowba.velocity.support.IndentableFileResourceLoader</code><br/>
 *
 * @author TAKAHASHI Tomoyuki
 *
 * <table border="1" cellpadding="3" cellspacing="0">
 * <tr bgcolor="#ccccff"><th>Ver.</th><th>t</th><th>ڍ</th></tr>
 * <tr><td>1.0</td><td>2008/01/12</td><td>VK쐬</td>
 * </table>
 */
public class IndentableFileResourceLoader extends FileResourceLoader {

    private String getOriginalContents(InputStream is, String enc) throws IOException {
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        try {
            int data;
            while ((data = is.read()) != -1) {
                baos.write(data);
            }
        } finally {
            if (baos != null) baos.close();
        }
        String originalContents = new String(baos.toByteArray(), enc);
        return originalContents;
    }

    @Override
    public InputStream getResourceStream(String templateName) throws ResourceNotFoundException {
        InputStream is = super.getResourceStream(templateName);

        try {
            String enc = (String)rsvc.getProperty("input.encoding");
            String originalContents = getOriginalContents(is, enc);
            Pattern pattern = Pattern.compile("^[ \\t]+#", Pattern.MULTILINE);
            String contents = pattern.matcher(originalContents).replaceAll("#");
            ByteArrayInputStream bais = new ByteArrayInputStream(contents.getBytes(enc));
            BufferedInputStream bis = new BufferedInputStream(bais);

            return bis;
        } catch (IOException e) {
            log.error("While loading Template " + templateName + ": ", e);
        }
        // IWiԋp
        return is;
    }

}
