/****************************************************************

    $Id: lpc.c,v 1.1 1996/02/28 08:58:08 koishida Exp koishida $

    LPC Analysis Using Levinson-Durbin method

   	int	lpc(x, flng, a, m);

	double  *x   : input sequence
	int    	flng : flame length
	double  *a   : LP coefficients
	int    	m    : order of LPC

	return value : 	0  -> normally completed
			-1 -> abnormally completed
			-2 -> unstable LPC

******************************************************************/

#include <stdio.h>
#include <SPTK.h>

int lpc(x, flng, a, m)
double *x, *a;
int flng, m;
{
    int		  flag;
    static double *r = NULL;
    static int	  size;
    
    if(r == NULL){
	r = dgetmem(m+1);
	size = m;
    }
    if(m > size){
	free(r);
	r = dgetmem(m+1);
	size = m;
    }
    
    acorr(x, flng, r, m);
    flag = levdur(r, a, m, -1);

    return(flag);
}
