package com.ozacc.springframework.mail.util;

import java.util.Map;

import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.ui.velocity.VelocityEngineUtils;

/**
 * 
 * @author Tomohiro Otsuka
 * @version $Id: VelocityMailerSupport.java,v 1.2 2004/04/20 04:45:46 otsuka Exp $
 */
public abstract class VelocityMailerSupport {

    protected VelocityEngine velocityEngine;

    protected JavaMailSender mailSender;

    /**
     * ꤵ줿Velocityƥץ졼Ȥcontextޡ
     * 줿ʸ֤ޤ
     * @param templatePath
     * @param context
     * @return ƥץ졼Ȥcontextޡ줿ʸ
     * @throws VelocityException
     */
    protected String mergeTemplateIntoString(String templatePath, Map context)
        throws VelocityException {
        if (velocityEngine == null)
            throw new IllegalStateException("VelocityEngineåȤƤޤ");

        return VelocityEngineUtils.mergeTemplateIntoString(velocityEngine, templatePath, context);
    }

    /**
     * @param sender JavaMailSender
     */
    public void setMailSender(JavaMailSender sender) {
        mailSender = sender;
    }

    /**
     * @param engine VelocityEngine
     */
    public void setVelocityEngine(VelocityEngine engine) {
        velocityEngine = engine;
    }

}