/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.springframework.mail.javamail;

import com.ozacc.springframework.mail.PlainMailMessage;
import com.ozacc.springframework.mail.javamail.IntlJavaMailSender;
import com.ozacc.springframework.mail.javamail.IntlMimeMessageHelper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class IntlJavaMailSenderImpl
extends JavaMailSenderImpl
implements IntlJavaMailSender {
    protected static final String DEFAULT_CHARSET = "iso-2022-jp";
    protected String charset = "iso-2022-jp";

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void send(PlainMailMessage plainMessage) throws MailException {
        this.send(new PlainMailMessage[]{plainMessage});
    }

    public void send(PlainMailMessage[] plainMessages) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
            int i = 0;
            while (i < plainMessages.length) {
                PlainMailMessage plainMessage = plainMessages[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending email using the following mail properties [" + (Object)((Object)plainMessage) + "]"));
                }
                MimeMessage mimeMessage = this.createMimeMessage();
                this.setNamedFromAndTo(plainMessage, mimeMessage);
                this.assenbleHeader(plainMessage, mimeMessage);
                mimeMessages.add(mimeMessage);
                ++i;
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), (Object[])plainMessages);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailParseException((Throwable)ex);
        }
        catch (MessagingException ex) {
            throw new MailParseException((Throwable)ex);
        }
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
            int i = 0;
            while (i < simpleMessages.length) {
                SimpleMailMessage simpleMessage = simpleMessages[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating MIME message using the following mail properties: " + simpleMessage));
                }
                IntlMimeMessageHelper message = new IntlMimeMessageHelper(this.createMimeMessage(), this.charset);
                if (simpleMessage.getFrom() != null) {
                    message.setFrom(simpleMessage.getFrom());
                }
                if (simpleMessage.getTo() != null) {
                    message.setTo(simpleMessage.getTo());
                }
                if (simpleMessage.getCc() != null) {
                    message.setCc(simpleMessage.getCc());
                }
                if (simpleMessage.getBcc() != null) {
                    message.setBcc(simpleMessage.getBcc());
                }
                if (simpleMessage.getSubject() != null) {
                    message.setSubject(simpleMessage.getSubject());
                }
                if (simpleMessage.getText() != null) {
                    message.setText(simpleMessage.getText());
                }
                mimeMessages.add(message.getMimeMessage());
                ++i;
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), simpleMessages);
        }
        catch (MessagingException ex) {
            throw new MailParseException((Throwable)ex);
        }
    }

    protected void setNamedFromAndTo(PlainMailMessage plainMessage, MimeMessage mimeMessage) throws MessagingException, UnsupportedEncodingException, AddressException {
        block7: {
            block6: {
                String[] toName;
                if (plainMessage.getFrom() != null && plainMessage.getFromName() != null) {
                    mimeMessage.setFrom((Address)new InternetAddress(plainMessage.getFrom(), plainMessage.getFromName(), this.charset));
                } else if (plainMessage.getFrom() != null) {
                    mimeMessage.setFrom((Address)new InternetAddress(plainMessage.getFrom()));
                }
                if (plainMessage.getTo() == null || plainMessage.getToName() == null) break block6;
                String[] to = plainMessage.getTo();
                if (to.length != (toName = plainMessage.getToName()).length) {
                    throw new IllegalStateException();
                }
                int i = 0;
                while (i < to.length) {
                    mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to[i], toName[i], this.charset));
                    ++i;
                }
                break block7;
            }
            if (plainMessage.getTo() == null) break block7;
            String[] to = plainMessage.getTo();
            int i = 0;
            while (i < to.length) {
                mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to[i]));
                ++i;
            }
        }
    }

    protected void assenbleHeader(SimpleMailMessage simpleMessage, MimeMessage mimeMessage) throws MessagingException, AddressException {
        int j;
        if (simpleMessage.getCc() != null) {
            j = 0;
            while (j < simpleMessage.getCc().length) {
                mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(simpleMessage.getCc()[j]));
                ++j;
            }
        }
        if (simpleMessage.getBcc() != null) {
            j = 0;
            while (j < simpleMessage.getBcc().length) {
                mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(simpleMessage.getBcc()[j]));
                ++j;
            }
        }
        if (simpleMessage.getSubject() != null) {
            mimeMessage.setSubject(simpleMessage.getSubject(), this.charset);
        }
        if (simpleMessage.getText() != null) {
            mimeMessage.setText(simpleMessage.getText(), this.charset);
        }
        mimeMessage.setSentDate(new Date());
        if (this.charset.equalsIgnoreCase(DEFAULT_CHARSET)) {
            mimeMessage.setHeader("Content-Transfer-Encoding", "7bit");
        }
    }
}

