/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.springframework.mail.javamail;

import com.ozacc.springframework.mail.MultipartMailMessage;
import com.ozacc.springframework.mail.javamail.IntlJavaMailSenderImpl;
import com.ozacc.springframework.mail.javamail.MultipartJavaMailSender;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;

public class MultipartJavaMailSenderImpl
extends IntlJavaMailSenderImpl
implements MultipartJavaMailSender {
    public void send(MultipartMailMessage multiPartMessage) throws MailException {
        this.send(new MultipartMailMessage[]{multiPartMessage});
    }

    public void send(MultipartMailMessage[] multiPartMessages) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
            int i = 0;
            while (i < multiPartMessages.length) {
                MultipartMailMessage multiPartMessage = multiPartMessages[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending email using the following mail properties [" + (Object)((Object)multiPartMessage) + "]"));
                }
                MimeMessage mimeMessage = this.createMimeMessage();
                this.setNamedFromAndTo(multiPartMessage, mimeMessage);
                this.assenbleHeader(multiPartMessage, mimeMessage);
                this.assembleBodyPart(multiPartMessage, mimeMessage);
                mimeMessages.add(mimeMessage);
                ++i;
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), (Object[])multiPartMessages);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailParseException((Throwable)ex);
        }
        catch (MessagingException ex) {
            throw new MailParseException((Throwable)ex);
        }
    }

    private void assembleBodyPart(MultipartMailMessage multiPartMessage, MimeMessage mimeMessage) throws MessagingException {
        MimeMultipart mp = new MimeMultipart();
        String body = multiPartMessage.getText();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText(body, this.charset);
        mp.addBodyPart((BodyPart)textPart);
        List files = multiPartMessage.getAttachments();
        Iterator itr = files.iterator();
        while (itr.hasNext()) {
            MimeBodyPart filePart = new MimeBodyPart();
            File file = (File)itr.next();
            filePart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
            filePart.setFileName(file.getName());
            mp.addBodyPart((BodyPart)filePart);
        }
        mimeMessage.setContent((Multipart)mp);
        mimeMessage.saveChanges();
    }
}

