package com.ozacc.springframework.mail.javamail;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;

import com.ozacc.springframework.mail.MultipartMailMessage;

/**
 * 
 * @author Tomohiro Otsuka
 * @version $Id: MultipartJavaMailSenderImpl.java,v 1.1 2004/02/11 06:58:46 otsuka Exp $
 */
public class MultipartJavaMailSenderImpl
	extends IntlJavaMailSenderImpl
	implements MultipartJavaMailSender {

	/**
	 * @see com.ozacc.springframework.mail.javamail.MultiPartJavaMailSender#send(com.ozacc.springframework.mail.MultiPartMailMessage)
	 */
	public void send(MultipartMailMessage multiPartMessage)
		throws MailException {
		send(new MultipartMailMessage[] { multiPartMessage });
	}

	/**
	 * @see com.ozacc.springframework.mail.javamail.MultiPartJavaMailSender#send(com.ozacc.springframework.mail.MultiPartMailMessage[])
	 */
	public void send(MultipartMailMessage[] multiPartMessages)
		throws MailException {
		try {
			List mimeMessages = new ArrayList();
			for (int i = 0; i < multiPartMessages.length; i++) {
				MultipartMailMessage multiPartMessage = multiPartMessages[i];

				if (logger.isDebugEnabled())
					logger.debug(
						"Sending email using the following mail properties ["
							+ multiPartMessage
							+ "]");

				MimeMessage mimeMessage = createMimeMessage();
				setNamedFromAndTo(multiPartMessage, mimeMessage);

				// Set Subject
				assenbleHeader(multiPartMessage, mimeMessage);

				assembleBodyPart(multiPartMessage, mimeMessage);

				mimeMessages.add(mimeMessage);
			}
			send(
				(MimeMessage[])mimeMessages.toArray(
					new MimeMessage[mimeMessages.size()]),
				multiPartMessages);
		} catch (UnsupportedEncodingException ex) {
			throw new MailParseException(ex);
		} catch (MessagingException ex) {
			throw new MailParseException(ex);
		}
	}

	/**
	 * @param multiPartMessage
	 * @param mimeMessage 
	 */
	private void assembleBodyPart(
		MultipartMailMessage multiPartMessage,
		MimeMessage mimeMessage)
		throws MessagingException {

		MimeMultipart mp = new MimeMultipart();

		// ʸ
		String body = multiPartMessage.getText();
		MimeBodyPart textPart = new MimeBodyPart();
		textPart.setText(body, charset);
		mp.addBodyPart(textPart);

		// źեե
		List files = multiPartMessage.getAttachments();
		for (Iterator itr = files.iterator(); itr.hasNext();) {
			MimeBodyPart filePart = new MimeBodyPart();
			File file = (File)itr.next();
			filePart.setDataHandler(new DataHandler(new FileDataSource(file)));
			filePart.setFileName(file.getName());

			mp.addBodyPart(filePart);
		}

		mimeMessage.setContent(mp);
		mimeMessage.saveChanges();
	}

}