package com.ozacc.springframework.mail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.mail.SimpleMailMessage;
import org.springframework.util.StringUtils;

/**
 * ̾ȺпͤǤ᡼롣
 * 
 * @author Tomohiro Otsuka
 * @version $Id: PlainMailMessage.java,v 1.1 2004/08/02 20:39:06 otsuka Exp $
 */
public class PlainMailMessage extends SimpleMailMessage {

    /** ̾ */
    protected String[] toName;

    /** п̾ */
    protected String fromName;

    /**
     * 󥹥ȥ饯
     */
    public PlainMailMessage() {
        super();
    }

    /**
     * Copy constructor.
     */
    public PlainMailMessage(PlainMailMessage original) {
        setFrom(original.getFrom());
        if (original.getFromName() != null)
            this.fromName = original.getFromName();

        setTo(original.getTo());
        if (original.getToName() != null)
            this.toName = original.getToName();

        if (original.getCc() != null) {
            String[] cc = new String[original.getCc().length];
            System.arraycopy(original.getCc(), 0, cc, 0, original.getCc().length);
            setCc(cc);
        }

        if (original.getBcc() != null) {
            String[] bcc = new String[original.getBcc().length];
            System.arraycopy(original.getBcc(), 0, bcc, 0, original.getBcc().length);
            setBcc(bcc);
        }
        setSubject(original.getSubject());
        setText(original.getText());
    }

    /**
     * ᡼򥻥åȤޤ
     * 
     * @param email ᡼륢ɥ쥹
     * @param name ̾
     */
    public void setTo(String email, String name) {
        setTo(email);
        this.toName = new String[] { name };
    }

    /**
     * ᡼ɲäޤ
     * 
     * @param email ᡼륢ɥ쥹
     * @param name ̾
     */
    public void addTo(String email, String name) {
        if (getTo() == null || getToName() == null) {
            setTo(email, name);
            return;
        }

        List toList = new ArrayList(Arrays.asList(getTo()));
        List toNameList = new ArrayList(Arrays.asList(toName));

        toList.add(email);
        toNameList.add(name);

        setTo((String[])toList.toArray(new String[toList.size()]));
        this.toName = (String[])toNameList.toArray(new String[toNameList.size()]);
    }

    /**
    * @return ̾
    */
    public String[] getToName() {
        return toName;
    }

    /**
     * @return п̾
     */
    public String getFromName() {
        return fromName;
    }

    /**
     * пͤΥ᡼륢ɥ쥹̾򥻥åȤޤ
     * 
     * @param email пͥ᡼륢ɥ쥹
     * @param name п̾
     */
    public void setFrom(String email, String name) {
        setFrom(email);
        setFromName(name);
    }

    /**
     * п̾򥻥åȤޤ
     * 
     * @param name п̾
     */
    public void setFromName(String name) {
        this.fromName = name;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer sb = new StringBuffer("PlainMailMessage [");

        sb.append("from: " + this.getFrom());
        if (fromName != null)
            sb.append(" <" + this.getFromName() + ">");
        sb.append("; ");

        for (int i = 0, num = this.getTo().length; i < num; i++) {
            if (num > 1)
                sb.append("[" + (i + 1) + "] ");
            sb.append("to: " + this.getTo()[i]);
            if (toName != null)
                sb.append(" <" + this.getToName()[i] + ">");

            if (i + 1 != num)
                sb.append(", ");
        }
        sb.append("; ");

        sb.append("cc: " + StringUtils.arrayToCommaDelimitedString(this.getCc()) + "; ");
        sb.append("subject: " + this.getSubject() + "; ");
        sb.append("text: " + this.getText() + "]");
        return sb.toString();
    }

}