package com.ozacc.springframework.mail.javamail;

import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;

import com.ozacc.springframework.mail.PlainMailMessage;

/**
 * JavaMailSenderĥPlainMailMessage᥽åɤ󥿡ե
 * 
 * @author Tomohiro Otsuka
 * @version $Id: IntlJavaMailSender.java,v 1.2 2004/08/03 13:14:54 otsuka Exp $
 */
public interface IntlJavaMailSender extends JavaMailSender {

	/**
	 * Send the given plain mail message.
	 * 
	 * @param plainMessage PlainMailMessage
	 * @throws MailException ˼Ԥ
	 */
	public void send(PlainMailMessage plainMessage) throws MailException;

	/**
	 * Send the given array of plain mail messages in batch.
	 * 
	 * @param plainMessages PlainMailMessage
	 * @throws MailException ˼Ԥ
	 */
	public void send(PlainMailMessage[] plainMessages) throws MailException;

}