package com.ozacc.springframework.mail.javamail;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.javamail.MimeMessageHelper;

import com.ozacc.springframework.mail.HtmlMailMessage;
import com.ozacc.springframework.mail.MultipartMailMessage;

/**
 * MultipartJavaMailSender󥿡եμ饹
 * 
 * @author Tomohiro Otsuka
 * @version $Id: MultipartJavaMailSenderImpl.java,v 1.1 2004/08/02 20:39:06 otsuka Exp $
 */
public class MultipartJavaMailSenderImpl
	extends IntlJavaMailSenderImpl
	implements MultipartJavaMailSender {

	/**
	 * @see com.ozacc.springframework.mail.javamail.MultiPartJavaMailSender#send(com.ozacc.springframework.mail.MultiPartMailMessage)
	 */
	public void send(MultipartMailMessage multiPartMessage) throws MailException {
		send(new MultipartMailMessage[] { multiPartMessage });
	}

	/**
	 * @see com.ozacc.springframework.mail.javamail.MultiPartJavaMailSender#send(com.ozacc.springframework.mail.MultiPartMailMessage[])
	 */
	public void send(MultipartMailMessage[] multiPartMessages) throws MailException {
		try {
			List mimeMessages = new ArrayList();
			for (int i = 0; i < multiPartMessages.length; i++) {
				MultipartMailMessage multiPartMessage = multiPartMessages[i];
				if (logger.isDebugEnabled())
					logger.debug(
						"Sending email using the following mail properties ["
							+ multiPartMessage
							+ "]");

				MimeMessageHelper message =
					new IntlMimeMessageHelper(createMimeMessage(), true, charset);
				assembleMailHeader(multiPartMessage, message);
				setText(multiPartMessage, message);

				// Attachments
				File[] attachments = multiPartMessage.getAttachments();
				for (int j = 0; j < attachments.length; j++) {
					File file = attachments[j];
					message.addAttachment(file.getName(), file);
				}

				mimeMessages.add(message.getMimeMessage());
			}
			send(
				(MimeMessage[])mimeMessages.toArray(new MimeMessage[mimeMessages.size()]),
				multiPartMessages);
		} catch (UnsupportedEncodingException ex) {
			throw new MailParseException(ex);
		} catch (MessagingException ex) {
			throw new MailParseException(ex);
		}
	}

	/**
	 * @see com.ozacc.springframework.mail.javamail.MultipartJavaMailSender#send(com.ozacc.springframework.mail.HtmlMailMessage)
	 */
	public void send(HtmlMailMessage htmlMessage) throws MailException {
		send(new HtmlMailMessage[] { htmlMessage });
	}

	/**
	 * @see com.ozacc.springframework.mail.javamail.MultipartJavaMailSender#send(com.ozacc.springframework.mail.HtmlMailMessage[])
	 */
	public void send(HtmlMailMessage[] htmlMessages) throws MailException {
		try {
			List mimeMessages = new ArrayList();
			for (int i = 0; i < htmlMessages.length; i++) {
				HtmlMailMessage htmlMessage = htmlMessages[i];
				if (logger.isDebugEnabled())
					logger.debug(
						"Sending email using the following mail properties [" + htmlMessage + "]");

				MimeMessageHelper message = new IntlMimeMessageHelper(createMimeMessage(), charset);
				assembleMailHeader(htmlMessage, message);
				createHtmlMessage(htmlMessage, message);
				mimeMessages.add(message.getMimeMessage());
			}
			send(
				(MimeMessage[])mimeMessages.toArray(new MimeMessage[mimeMessages.size()]),
				htmlMessages);
		} catch (UnsupportedEncodingException ex) {
			throw new MailParseException(ex);
		} catch (MessagingException ex) {
			throw new MailParseException(ex);
		}
	}

	/**
	 * HTMLåޤ
	 * 
	 * @param htmlMessage
	 * @param message
	 * @throws MessagingException
	 */
	protected void createHtmlMessage(HtmlMailMessage htmlMessage, MimeMessageHelper message)
		throws MessagingException {
		MimeMessage mimeMessage = message.getMimeMessage();

		MimeMultipart mp = new MimeMultipart("alternative");
		// TEXT Part
		if (htmlMessage.getText() != null) {
			MimeBodyPart textPart = new MimeBodyPart();
			if (message.getEncoding() != null) {
				textPart.setText(htmlMessage.getText() + "\n", message.getEncoding());
				if (JIS_ENCODING.equalsIgnoreCase(charset)) {
					textPart.setHeader("Content-Transfer-Encoding", "7bit");
				}
			} else {
				textPart.setText(htmlMessage.getText());
			}
			mp.addBodyPart(textPart);
		}
		// HTML Part
		if (htmlMessage.getHtml() != null) {
			MimeBodyPart htmlPart = new MimeBodyPart();
			String contentType =
				message.getEncoding() == null
					? "text/html"
					: "text/html; charset=" + message.getEncoding();
			htmlPart.setContent(htmlMessage.getHtml(), contentType);
			if (JIS_ENCODING.equalsIgnoreCase(charset)) {
				htmlPart.setHeader("Content-Transfer-Encoding", "7bit");
			}
			mp.addBodyPart(htmlPart);
		}

		mimeMessage.setContent(mp);
		mimeMessage.saveChanges();
	}

}