package com.ozacc.mail.spring;

import java.io.File;

import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.XMLMailBuilder;

/**
 * Springեǻꤵ줿XMLե뤫Mail󥹥󥹤FactoryBean
 * ǥեȤǤϡsingletonץѥƥfalseꤵޤ
 * <p>
 * locationclassPathfilePathνǡ˥åȤƤץѥƥͤXMLեΥѥȤƻȤޤ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailFactoryBean.java,v 1.2 2004/09/11 01:41:59 otsuka Exp $
 */
public class XMLMailFactoryBean extends AbstractFactoryBean {

	private String classPath;

	private String filePath;

	private Resource location;

	private XMLMailBuilder mailBuilder;

	/**
	 * 󥹥ȥ饯
	 */
	public XMLMailFactoryBean() {
		mailBuilder = XMLMailBuilder.getInstance();
		setSingleton(false);
	}

	/**
	 * @see org.springframework.beans.factory.config.AbstractFactoryBean#createInstance()
	 */
	protected Object createInstance() throws Exception {
		if (getLocation() != null && getLocation().getFile() != null) {
			return mailBuilder.buildMail(getLocation().getFile());
		}
		if (getClassPath() != null) {
			return mailBuilder.buildMail(getClassPath());
		}
		if (getFilePath() != null) {
			return mailBuilder.buildMail(new File(getFilePath()));
		}
		throw new MailBuildException("Mail󥹥󥹤˼ԤޤXMLǡΥ󤬻ꤵƤޤ");
	}

	/**
	 * @see org.springframework.beans.factory.FactoryBean#getObjectType()
	 */
	public Class getObjectType() {
		return Mail.class;
	}

	/**
	 * @return Returns the classPath.
	 */
	public String getClassPath() {
		return classPath;
	}

	/**
	 * @param classPath The classPath to set.
	 */
	public void setClassPath(String classPath) {
		this.classPath = classPath;
	}

	/**
	 * @return Returns the filePath.
	 */
	public String getFilePath() {
		return filePath;
	}

	/**
	 * @param filePath The filePath to set.
	 */
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	/**
	 * @return Returns the location.
	 */
	public Resource getLocation() {
		return location;
	}

	/**
	 * @param location The location to set.
	 */
	public void setLocation(Resource location) {
		this.location = location;
	}
}