package com.ozacc.mail.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailBuilder;

/**
 * ᡼ǡXMLե뤫Mail󥹥󥹤륯饹
 * <p>
 * XMLɤ߹ݤˡDTDХǡ󤬼¹ԤޤΤXMLǡ(Valid XML Document)ǤʤФޤ
 * ᡼ǡXMLDTDϡ<a href="http://www.ozacc.com/library/dtd/ozacc-mail.dtd">http://www.ozacc.com/library/dtd/ozacc-mail.dtd</a>򻲾ȡ
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailBuilderImpl.java,v 1.1 2004/09/13 07:07:11 otsuka Exp $
 */
public class XMLMailBuilderImpl implements MailBuilder {

	private DocumentBuilder db;

	/**
	 * @see com.ozacc.mail.MailBuilder#buildMail(java.lang.String)
	 */
	public Mail buildMail(String classPath) throws MailBuildException {
		Document doc;
		try {
			doc = getDocumentFromClassPath(classPath);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}

		return build(doc);
	}

	/**
	 * @param classPath
	 * @return 
	 * @throws IOException
	 * @throws SAXException
	 */
	protected synchronized Document getDocumentFromClassPath(String classPath) throws SAXException,
																				IOException {
		InputStream is = getClass().getResourceAsStream(classPath);
		DocumentBuilder db = createDocumentBuilder();
		try {
			return db.parse(is);
		} finally {
			if (is != null) {
				is.close();
			}
		}
	}

	/**
	 * @see com.ozacc.mail.MailBuilder#buildMail(java.io.File)
	 */
	public Mail buildMail(File file) throws MailBuildException {
		Document doc;
		try {
			doc = getDocumentFromFile(file);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}

		return build(doc);
	}

	/**
	 * DOM DocumentMail󥹥󥹤ޤ
	 * 
	 * @param doc ᡼ǡDOM Document
	 * @return 줿Mail󥹥
	 */
	protected Mail build(Document doc) {
		Element root = doc.getDocumentElement();

		Mail mail = new Mail();
		setReturnPath(root, mail);
		setFrom(root, mail);
		setRecipients(root, mail);
		setReplyTo(root, mail);
		setSubject(root, mail);
		setText(root, mail);

		return mail;
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setReplyTo(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("replyTo");
		Element replyTo = (Element)nodes.item(0);
		if (replyTo != null && replyTo.getAttribute("email").length() > 0) {
			mail.setReplyTo(replyTo.getAttribute("email"));
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setText(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("body");
		Element bodyElem = (Element)nodes.item(0);
		if (bodyElem == null) {
			return;
		}
		String body = bodyElem.getFirstChild().getNodeValue();
		mail.setText(body.trim());
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setSubject(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("subject");
		Element subjectElem = (Element)nodes.item(0);
		if (subjectElem == null) {
			return;
		}
		String subject = subjectElem.getFirstChild().getNodeValue();
		mail.setSubject(subject.trim());
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setRecipients(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("recipients");
		Element recipientsElem = (Element)nodes.item(0);
		if (recipientsElem == null) {
			return;
		}

		NodeList recipientElemList = recipientsElem.getChildNodes();
		for (int i = 0, max = recipientElemList.getLength(); i < max; i++) {
			Node node = recipientElemList.item(i);
			if (node.getNodeType() != Node.ELEMENT_NODE) {
				continue;
			}
			Element e = (Element)node;
			if ("to".equals(e.getNodeName())) { // to
				if (e.getAttribute("email").length() > 0) {
					if (e.getAttribute("name").length() > 0) {
						mail.addTo(e.getAttribute("email"), e.getAttribute("name"));
					} else {
						mail.addTo(e.getAttribute("email"));
					}
				}
			} else if ("cc".equals(e.getNodeName())) { // cc
				if (e.getAttribute("email").length() > 0) {
					if (e.getAttribute("name").length() > 0) {
						mail.addCc(e.getAttribute("email"), e.getAttribute("name"));
					} else {
						mail.addCc(e.getAttribute("email"));
					}
				}
			} else {
				if (e.getAttribute("email").length() > 0) { // bcc
					mail.addBcc(e.getAttribute("email"));
				}
			}
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setReturnPath(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("returnPath");
		Element returnPath = (Element)nodes.item(0);
		if (returnPath != null && returnPath.getAttribute("email").length() > 0) {
			mail.setReturnPath(returnPath.getAttribute("email"));
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setFrom(Element root, Mail mail) {
		NodeList nodes = root.getElementsByTagName("from");
		Element from = (Element)nodes.item(0);
		if (from != null && from.getAttribute("email").length() > 0) {
			if (from.getAttribute("name").length() > 0) {
				mail.setFrom(from.getAttribute("email"), from.getAttribute("name"));
			} else {
				mail.setFrom(from.getAttribute("email"));
			}
		}
	}

	/**
	 * DocumentBuilderϥåɥդǤϤʤᡢƱ᥽åɤˡ
	 * 
	 * @param file
	 * @return DOM Document
	 * @throws IOException
	 * @throws SAXException
	 */
	protected synchronized Document getDocumentFromFile(File file) throws SAXException, IOException {
		DocumentBuilder db = createDocumentBuilder();
		return db.parse(file);
	}

	/**
	 * @return DocumentBuilder
	 * @throws FactoryConfigurationError 
	 */
	protected DocumentBuilder createDocumentBuilder() throws FactoryConfigurationError {
		if (db == null) {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			dbf.setIgnoringComments(true);
			dbf.setIgnoringElementContentWhitespace(true);
			dbf.setValidating(true);
			try {
				db = dbf.newDocumentBuilder();
			} catch (ParserConfigurationException e) {
				// never be thrown
				throw new RuntimeException(e);
			}
		}
		return db;
	}

}