package com.ozacc.mail.spring;

import junit.framework.TestCase;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

import com.ozacc.mail.Mail;
import com.ozacc.mail.mock.AssertionFailedException;
import com.ozacc.mail.mock.MockSendMail;

/**
 * XMLMailFactoryBeanTestCase
 * 
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailFactoryBeanTest.java,v 1.4 2004/09/11 01:42:05 otsuka Exp $
 */
public class XMLMailFactoryBeanTest extends TestCase {

	Mail mail;

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	public void setUp() throws Exception {
		super.setUp();

		mail = new Mail();
		mail.setSubject("XMLMailBuilderΥƥȥ");
		mail.setText("Ԥޤ\nԤޤ\nƥȤ");
		mail.setFrom("from@example.com", "п");
		mail.setReturnPath("return@example.com");
		mail.setReplyTo("reply@example.com");
		mail.addTo("to1@example.com", "1");
		mail.addTo("to2@example.com");
		mail.addCc("cc1@example.com", "CC1");
		mail.addCc("cc2@example.com");
		mail.addBcc("bcc@example.com");
	}

	public void testMailFactoryBeanClassPathFail() throws Exception {
		mail.addBcc("ccb@example.com");

		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail");

		try {
			MockSendMail.checkEquality(mail, result, 1);
			fail("This should never be called.");
		} catch (AssertionFailedException expected) {
			//success
		}
	}

	public void testMailFactoryBeanClassPath() throws Exception {
		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail");

		MockSendMail.checkEquality(mail, result, 1);
	}

	public void testMailFactoryBeanFilePath() throws Exception {
		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail2");

		MockSendMail.checkEquality(mail, result, 1);
	}

	public void testMailFactoryBeanLocation() throws Exception {
		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail3");

		MockSendMail.checkEquality(mail, result, 1);
	}

	public void testMailFactoryBeanLocationClasspath() throws Exception {
		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail4");

		MockSendMail.checkEquality(mail, result, 1);
	}

}