package com.ozacc.mail.impl;

import java.io.File;

import javax.mail.internet.InternetAddress;

import junit.framework.TestCase;

import org.apache.velocity.VelocityContext;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.VelocityMailBuilder;

/**
 * XMLMailBuilderΥƥȥ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: JDomXMLMailBuilderTest.java,v 1.1 2004/09/04 13:55:17 otsuka Exp $
 */
public class JDomXMLMailBuilderTest extends TestCase {

	private VelocityMailBuilder builder;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		builder = new JDomXMLMailBuilder();
	}

	/*
	 * Class under test for Mail buildMail(String)
	 * ¸ߤʤեΥѥꤷƼԡ
	 */
	public final void testBuildMailFromClassPathNotExist() throws Exception {
		String classPath = "/com/ozacc/mail/testtest-mail1.xml";
		try {
			Mail result = builder.buildMail(classPath);
			fail("This should never be called.");
		} catch (MailBuildException expected) {
			// success
		}
	}

	/*
	 * Class under test for Mail buildMail(File)
	 * ¸ߤʤեꤷƼ
	 */
	public final void testBuildMailFromFileNotExist() throws Exception {
		String path = "src/test/com/ozacc/mail/testtest-mail1.xml";
		File file = new File(path);
		try {
			Mail result = builder.buildMail(file);
			fail("This should never be called.");
		} catch (MailBuildException expected) {
			// success
		}
	}

	/*
	 * Class under test for Mail buildMail(String)
	 * DTDȿXMLΤἺԡ
	 */
	public final void testBuildMailFromClassPathInvalidXML() throws Exception {
		String classPath = "/com/ozacc/mail/test-mail2-invalid.xml";
		try {
			Mail result = builder.buildMail(classPath);
			fail("This should never be called.");
		} catch (MailBuildException expected) {
			// success
		}
	}

	/*
	 * Class under test for Mail buildMail(String)
	 * XMLեΥ饹ѥMail󥹥󥹤
	 */
	public final void testBuildMailFromClassPath() throws Exception {
		String classPath = "/com/ozacc/mail/test-mail1.xml";

		String subject = "XMLMailBuilderΥƥȥ";
		String text = "Ԥޤ\nԤޤ\nƥȤ";

		InternetAddress from = new InternetAddress("from@example.com", "п");
		InternetAddress returnPath = new InternetAddress("return@example.com");
		InternetAddress replyTo = new InternetAddress("reply@example.com");

		InternetAddress to1 = new InternetAddress("to1@example.com", "1");
		InternetAddress to2 = new InternetAddress("to2@example.com");

		InternetAddress cc1 = new InternetAddress("cc1@example.com", "CC1");
		InternetAddress cc2 = new InternetAddress("cc2@example.com");

		InternetAddress bcc = new InternetAddress("bcc@example.com");

		Mail result = builder.buildMail(classPath);

		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());

		assertEquals(from, result.getFrom());
		assertEquals(returnPath, result.getReturnPath());
		assertEquals(replyTo, result.getReplyTo());

		InternetAddress[] tos = result.getTo();
		assertEquals(2, tos.length);
		assertEquals(to1, tos[0]);
		assertEquals(to2, tos[1]);

		InternetAddress[] ccs = result.getCc();
		assertEquals(2, ccs.length);
		assertEquals(cc1, ccs[0]);
		assertEquals(cc2, ccs[1]);

		InternetAddress[] bccs = result.getBcc();
		assertEquals(1, bccs.length);
		assertEquals(bcc, bccs[0]);
	}

	/*
	 * Class under test for Mail buildMail(File)
	 * XMLեFile󥹥󥹤Mail󥹥󥹤
	 */
	public final void testBuildMailFromFile() throws Exception {
		String path = "src/test/com/ozacc/mail/test-mail1.xml";
		File file = new File(path);

		String subject = "XMLMailBuilderΥƥȥ";
		String text = "Ԥޤ\nԤޤ\nƥȤ";

		InternetAddress from = new InternetAddress("from@example.com", "п");
		InternetAddress returnPath = new InternetAddress("return@example.com");
		InternetAddress replyTo = new InternetAddress("reply@example.com");

		InternetAddress to1 = new InternetAddress("to1@example.com", "1");
		InternetAddress to2 = new InternetAddress("to2@example.com");

		InternetAddress cc1 = new InternetAddress("cc1@example.com", "CC1");
		InternetAddress cc2 = new InternetAddress("cc2@example.com");

		InternetAddress bcc = new InternetAddress("bcc@example.com");

		Mail result = builder.buildMail(file);

		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());

		assertEquals(from, result.getFrom());
		assertEquals(returnPath, result.getReturnPath());
		assertEquals(replyTo, result.getReplyTo());

		InternetAddress[] tos = result.getTo();
		assertEquals(2, tos.length);
		assertEquals(to1, tos[0]);
		assertEquals(to2, tos[1]);

		InternetAddress[] ccs = result.getCc();
		assertEquals(2, ccs.length);
		assertEquals(cc1, ccs[0]);
		assertEquals(cc2, ccs[1]);

		InternetAddress[] bccs = result.getBcc();
		assertEquals(1, bccs.length);
		assertEquals(bcc, bccs[0]);
	}

	/*
	 * Class under test for Mail buildMail(String, VelocityContext)
	 */
	public final void testBuildMailStringVelocityContext() throws Exception {
		String classPath = "/com/ozacc/mail/test-mail3-velocity.xml";

		String name = "";
		String email = "misaki@example.com";
		Customer customer = new Customer(name, email);

		InternetAddress from = new InternetAddress("shop@example.com", "XMLMailBuilder饤󥷥å");
		InternetAddress to = new InternetAddress(email, name);

		String subject = "XMLMailBuilder饤󥷥å - ʸγǧ";
		String text = name + "\n\n㤤夲꤬Ȥޤ";

		VelocityContext context = new VelocityContext();
		context.put("customer", customer);

		// ᡼¹
		Mail result = builder.buildMail(classPath, context);

		assertEquals(from, result.getFrom());
		assertEquals(to, result.getTo()[0]);
		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());
	}

	/*
	 * Class under test for Mail buildMail(File, VelocityContext)
	 */
	public final void testBuildMailFileVelocityContext() throws Exception {
		String path = "src/test/com/ozacc/mail/test-mail3-velocity.xml";
		File file = new File(path);

		String name = "";
		String email = "misaki@example.com";
		Customer customer = new Customer(name, email);

		InternetAddress from = new InternetAddress("shop@example.com", "XMLMailBuilder饤󥷥å");
		InternetAddress to = new InternetAddress(email, name);

		String subject = "XMLMailBuilder饤󥷥å - ʸγǧ";
		String text = name + "\n\n㤤夲꤬Ȥޤ";

		VelocityContext context = new VelocityContext();
		context.put("customer", customer);

		// ᡼¹
		Mail result = builder.buildMail(file, context);

		assertEquals(from, result.getFrom());
		assertEquals(to, result.getTo()[0]);
		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());
	}

	public static class Customer {

		private String name;

		private String email;

		public Customer(String name, String email) {
			this.name = name;
			this.email = email;
		}

		/**
		 * @return Returns the email.
		 */
		public String getEmail() {
			return email;
		}

		/**
		 * @param email The email to set.
		 */
		public void setEmail(String email) {
			this.email = email;
		}

		/**
		 * @return Returns the name.
		 */
		public String getName() {
			return name;
		}

		/**
		 * @param name The name to set.
		 */
		public void setName(String name) {
			this.name = name;
		}
	}

}