/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.rss.impl;

import com.ozacc.blog.rss.ParseException;
import com.ozacc.blog.rss.ParseTimeoutException;
import com.ozacc.blog.rss.RSSAutoDiscovery;
import com.ozacc.blog.util.DefaultHTMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RSSAutoDiscoveryImpl
implements RSSAutoDiscovery {
    private static Log log;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.blog.rss.impl.RSSAutoDiscoveryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public URL[] discoverRSSUrls(URL url) throws ParseException {
        return this.discoverRSSUrls(url.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL[] discoverRSSUrls(String url) throws ParseException {
        URL[] uRLArray;
        HttpClient client = new HttpClient();
        log.debug((Object)("\u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.connectionTimeout + "]"));
        client.setConnectionTimeout(this.connectionTimeout);
        log.debug((Object)("\u8aad\u8fbc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.readTimeout + "]"));
        client.setTimeout(this.readTimeout);
        GetMethod method = new GetMethod(url);
        try {
            try {
                log.debug((Object)("HTTP\u63a5\u7d9a\u3092\u884c\u3044\u307e\u3059\u3002[" + url + "]"));
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    throw new ParseException("HTTP\u63a5\u7d9a\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[HTTP_STATUS='" + HttpStatus.getStatusText((int)statusCode) + "', url='" + url + "']");
                }
                InputStream is = method.getResponseBodyAsStream();
                uRLArray = this.parse(is);
                Object var6_10 = null;
            }
            catch (HttpConnection.ConnectionTimeoutException e) {
                throw new ParseTimeoutException("HTTP\u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3002[url='" + url + "']", e);
            }
            catch (HttpRecoverableException e) {
                throw new ParseTimeoutException("HTTP\u8aad\u8fbc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3002[url='" + url + "']", e);
            }
            catch (IOException e) {
                throw new ParseException("RSS\u30aa\u30fc\u30c8\u30c7\u30a3\u30b9\u30ab\u30d0\u30ea\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[url='" + url + "']", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            method.releaseConnection();
            throw throwable;
        }
        method.releaseConnection();
        return uRLArray;
    }

    private URL[] parse(InputStream is) throws IOException, MalformedURLException {
        URL[] uRLArray;
        block3: {
            InputStreamReader reader = new InputStreamReader(is);
            try {
                HTMLEditorKit.Parser parser = new DefaultHTMLParser().getParser();
                HTMLParserCallback callback = new HTMLParserCallback();
                parser.parse(reader, callback, true);
                String[] urls = callback.getRSSUrls();
                URL[] result = new URL[urls.length];
                int i = 0;
                while (i < urls.length) {
                    result[i] = new URL(urls[i]);
                    ++i;
                }
                uRLArray = result;
                Object var8_9 = null;
                if (reader == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_10 = null;
                    if (reader == null) break block4;
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        return uRLArray;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    private class HTMLParserCallback
    extends HTMLEditorKit.ParserCallback {
        private List rssUrls = new ArrayList();

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.LINK) {
                String rssUrl;
                String rel = (String)a.getAttribute(HTML.Attribute.REL);
                String type = (String)a.getAttribute(HTML.Attribute.TYPE);
                if ("alternate".equalsIgnoreCase(rel) && "application/rss+xml".equalsIgnoreCase(type) && (rssUrl = (String)a.getAttribute(HTML.Attribute.HREF)) != null) {
                    this.rssUrls.add(rssUrl);
                }
            }
        }

        public String[] getRSSUrls() {
            return this.rssUrls.toArray(new String[this.rssUrls.size()]);
        }
    }
}

