package com.ozacc.blog.rss.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTML.Tag;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.HttpConnection.ConnectionTimeoutException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.blog.rss.ParseException;
import com.ozacc.blog.rss.ParseTimeoutException;
import com.ozacc.blog.rss.RSSAutoDiscovery;
import com.ozacc.blog.util.CommonsHttpClientUtils;
import com.ozacc.blog.util.DefaultHTMLParser;

/**
 * RSSAutoDiscovery󥿡եμ饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: RSSAutoDiscoveryImpl.java,v 1.2.2.4 2004/12/09 14:28:22 otsuka Exp $
 */
public class RSSAutoDiscoveryImpl implements RSSAutoDiscovery {

	private static Log log = LogFactory.getLog(RSSAutoDiscoveryImpl.class);

	public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

	public static final int DEFAULT_READ_TIMEOUT = 5000;

	private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;

	private int readTimeout = DEFAULT_READ_TIMEOUT;

	private boolean followRedirect = true;

	/**
	 * @see com.ozacc.blog.rss.RSSAutoDiscovery#discoverRSSUrls(java.net.URL)
	 */
	public URL[] discoverRSSUrls(URL url) throws ParseException {
		return discoverRSSUrls(url.toString());
	}

	/**
	 * @see com.ozacc.blog.rss.RSSAutoDiscovery#discoverRSSUrls(java.lang.String)
	 */
	public URL[] discoverRSSUrls(String url) throws ParseException {
		HttpClient client = new HttpClient();
		log.debug("³ॢȤꤷޤ[" + connectionTimeout + "]");
		client.setConnectionTimeout(connectionTimeout);
		log.debug("ɹॢȤꤷޤ[" + readTimeout + "]");
		client.setTimeout(readTimeout);

		HttpMethod method = new GetMethod(url);
		method.setFollowRedirects(followRedirect);
		try {
			log.debug("HTTP³Ԥޤ[" + url + "]");
			int statusCode = client.executeMethod(method);
			if (!CommonsHttpClientUtils.isSuccessfulResponse(statusCode, followRedirect)) {
				throw new ParseException("HTTP³ǤޤǤ[HTTP_STATUS='"
						+ HttpStatus.getStatusText(statusCode) + "', url='" + url + "']");
			}
			InputStream is = method.getResponseBodyAsStream();
			return parse(is);
		} catch (ConnectionTimeoutException e) {
			throw new ParseTimeoutException("HTTP³ॢȡ[url='" + url + "']", e);
		} catch (HttpRecoverableException e) {
			throw new ParseTimeoutException("HTTPɹॢȡ[url='" + url + "']", e);
		} catch (IOException e) {
			throw new ParseException("RSSȥǥХ꡼˼Ԥޤ[url='" + url + "']", e);
		} finally {
			method.releaseConnection();
		}
	}

	/**
	 * @param is
	 * @return
	 * @throws IOException
	 * @throws MalformedURLException 
	 */
	private URL[] parse(InputStream is) throws IOException, MalformedURLException {
		InputStreamReader reader = new InputStreamReader(is);
		try {
			HTMLEditorKit.Parser parser = new DefaultHTMLParser().getParser();
			HTMLParserCallback callback = new HTMLParserCallback();
			parser.parse(reader, callback, true);

			String[] urls = callback.getRSSUrls();
			URL[] result = new URL[urls.length];
			for (int i = 0; i < urls.length; i++) {
				result[i] = new URL(urls[i]);
			}
			return result;
		} finally {
			if (reader != null) {
				reader.close();
			}
		}
	}

	private class HTMLParserCallback extends HTMLEditorKit.ParserCallback {

		private List rssUrls;

		public HTMLParserCallback() {
			rssUrls = new ArrayList();
		}

		/**
		 * @see javax.swing.text.html.HTMLEditorKit.ParserCallback#handleSimpleTag(javax.swing.text.html.HTML.Tag, javax.swing.text.MutableAttributeSet, int)
		 */
		public void handleSimpleTag(Tag t, MutableAttributeSet a, int pos) {
			if (t == HTML.Tag.LINK) {
				String rel = (String)a.getAttribute(HTML.Attribute.REL);
				String type = (String)a.getAttribute(HTML.Attribute.TYPE);
				if ("alternate".equalsIgnoreCase(rel)
						&& "application/rss+xml".equalsIgnoreCase(type)) {
					String rssUrl = (String)a.getAttribute(HTML.Attribute.HREF);
					if (rssUrl != null) {
						rssUrls.add(rssUrl);
					}
				}
			}
		}

		public String[] getRSSUrls() {
			return (String[])rssUrls.toArray(new String[rssUrls.size()]);
		}
	}

	/**
	 * ³ॢȻ֤򥻥åȤޤñ̤ϥߥá
	 * ǥեȤ5,000ߥ(5)Ǥ
	 * 
	 * @param connectionTimeout ³ॢ (ms)
	 */
	public void setConnectionTimeout(int connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	/**
	 * ³ɹॢȻ֤򥻥åȤޤñ̤ϥߥá
	 * ǥեȤ5,000ߥ(5)Ǥ
	 * 
	 * @param timeout ɹॢ (ms)
	 */
	public void setReadTimeout(int timeout) {
		this.readTimeout = timeout;
	}

	/**
	 * URL쥯ȥ쥹ݥ(HTTP Status Code 3xx)֤Ƥˡ
	 * 쥯˥뤫ɤꤷޤǥեȤǤϡ쥯˥ޤ
	 * 
	 * @param followRedirect 쥯˥ trueǥեȤtrue
	 */
	public void setFollowRedirect(boolean followRedirect) {
		this.followRedirect = followRedirect;
	}
}