package com.ozacc.blog.rss.informa;

import java.io.IOException;
import java.io.InputStream;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.ParseException;
import com.ozacc.blog.rss.support.XmlInputStreamParser;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;

/**
 * XmlInputStreamParser󥿡եInforma
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: XmlInputStreamParserImpl.java,v 1.1.2.1 2004/12/04 10:16:21 otsuka Exp $
 */
public class XmlInputStreamParserImpl implements XmlInputStreamParser {

	/**
	 * @see com.ozacc.blog.rss.support.XmlInputStreamParser#parseXmlInputStream(java.io.InputStream)
	 */
	public Channel parseXmlInputStream(InputStream is) throws ParseException {
		ChannelIF channelIF;
		try {
			channelIF = FeedParser.parse(new ChannelBuilder(), is);
		} catch (IOException e) {
			throw new ParseException("RSS XMLΥѡ˼Ԥޤ", e);
		} catch (de.nava.informa.core.ParseException e) {
			throw new ParseException("RSS XMLΥѡ˼Ԥޤ", e);
		}
		return new ChannelAdapter(channelIF);
	}

}