/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.rss.informa;

import com.ozacc.blog.util.DateFormat;
import de.nava.informa.core.ChannelExporterIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.ParserUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RSS_2_0_Exporter
implements ChannelExporterIF {
    private static final String RSS_VERSION = "2.0";
    private static final String NS_DC = "http://purl.org/dc/elements/1.1/";
    private static final String NS_SY = "http://purl.org/rss/1.0/modules/syndication/";
    private static final String NS_ADMIN = "http://webns.net/mvcb/";
    private static final String NS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private Writer writer;
    private String encoding;

    public RSS_2_0_Exporter(String filename) throws IOException {
        this(new File(filename), "utf-8");
    }

    public RSS_2_0_Exporter(File file) throws IOException {
        this(file, "utf-8");
    }

    public RSS_2_0_Exporter(File file, String encoding) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        this.encoding = encoding;
    }

    public RSS_2_0_Exporter(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    public void write(ChannelIF channel) throws IOException {
        if (this.writer == null) {
            throw new RuntimeException("No writer has been initialized.");
        }
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        Document doc = RSS_2_0_Exporter.getJdomDocument(channel);
        outputter.output(doc, this.writer);
        this.writer.close();
    }

    public static Document getJdomDocument(ChannelIF channel) {
        Namespace dcNs = Namespace.getNamespace((String)"dc", (String)NS_DC);
        Namespace syNs = Namespace.getNamespace((String)"sy", (String)NS_SY);
        Namespace adminNs = Namespace.getNamespace((String)"admin", (String)NS_ADMIN);
        Namespace rdfNs = Namespace.getNamespace((String)"rdf", (String)NS_RDF);
        Element rootElem = new Element("rss");
        rootElem.addNamespaceDeclaration(dcNs);
        rootElem.addNamespaceDeclaration(syNs);
        rootElem.addNamespaceDeclaration(adminNs);
        rootElem.setAttribute("version", RSS_VERSION);
        Element channelElem = new Element("channel");
        channelElem.addContent((Content)new Element("title").setText(channel.getTitle()));
        if (channel.getSite() != null) {
            channelElem.addContent((Content)new Element("link").setText(channel.getSite().toString()));
        }
        channelElem.addContent((Content)new Element("description").setText(channel.getDescription()));
        if (channel.getLanguage() != null) {
            channelElem.addContent((Content)new Element("language", dcNs).setText(channel.getLanguage()));
        }
        if (channel.getCopyright() != null) {
            channelElem.addContent((Content)new Element("copyright", dcNs).setText(channel.getCopyright()));
        }
        if (channel.getCreator() != null) {
            channelElem.addContent((Content)new Element("creator", dcNs).setText(channel.getCreator()));
        }
        if (channel.getLastUpdated() != null) {
            channelElem.addContent((Content)new Element("date", dcNs).setText(DateFormat.format(channel.getLastUpdated())));
        }
        if (channel.getUpdateBase() != null) {
            channelElem.addContent((Content)new Element("updateBase", syNs).setText(df.format(channel.getUpdateBase())));
        }
        if (channel.getUpdatePeriod() != null) {
            channelElem.addContent((Content)new Element("updateFrequency", syNs).setText(new Integer(channel.getUpdateFrequency()).toString()));
            channelElem.addContent((Content)new Element("updatePeriod", syNs).setText(channel.getUpdatePeriod()));
        }
        Collection items = channel.getItems();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            ItemIF item = (ItemIF)it.next();
            Element itemElem = new Element("item");
            itemElem.addContent((Content)new Element("title").setText(item.getTitle()));
            if (item.getLink() != null) {
                itemElem.addContent((Content)new Element("link").setText(item.getLink().toString()));
            }
            if (item.getDescription() != null) {
                itemElem.addContent((Content)new Element("description").setText(item.getDescription()));
            }
            if (item.getDate() != null) {
                itemElem.addContent((Content)new Element("pubDate").setText(ParserUtils.formatDate((Date)item.getDate())));
            }
            if (item.getSubject() != null) {
                itemElem.addContent((Content)new Element("subject", dcNs).setText(item.getSubject()));
            }
            if (item.getLink() != null) {
                Element guid = new Element("guid").setText(item.getLink().toString());
                guid.setAttribute("isPermaLink", "true");
                itemElem.addContent((Content)guid);
            }
            if (item.getComments() != null) {
                itemElem.addContent((Content)new Element("comments").setText(item.getComments().toString()));
            }
            channelElem.addContent((Content)itemElem);
        }
        rootElem.addContent((Content)channelElem);
        return new Document(rootElem);
    }

    public static org.w3c.dom.Document getDocument(ChannelIF channel) throws JDOMException {
        Document doc = RSS_2_0_Exporter.getJdomDocument(channel);
        DOMOutputter outputter = new DOMOutputter();
        return outputter.output(doc);
    }
}

