package com.ozacc.mail.fetch.impl;

import java.util.Properties;

import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.mail.MailAuthenticationException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.NotConnectedException;
import com.ozacc.mail.fetch.FetchMailPro;
import com.ozacc.mail.fetch.MailFetchException;
import com.ozacc.mail.fetch.ReceivedMail;

/**
 * <code>FetchMail</code>󥿡եμ饹
 * <p>
 * Υ饹Υ󥹥󥹤ϡ󥹥ѿѤƾ֤ݻ뤿ᡢ
 * ơȥ쥹ǤϤޤ󡣥ơȥեǤ
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: FetchMailProImpl.java,v 1.1.2.6 2004/11/25 08:00:16 otsuka Exp $
 */
public class FetchMailProImpl implements FetchMailPro {

	private static Log log = LogFactory.getLog(FetchMailProImpl.class);

	/** ǥեȤSMTPСlocalhost */
	public static final String DEFAULT_HOST = "localhost";

	/** ǥեȤΥץȥ롣pop3 */
	public static final String DEFAULT_PROTOCOL = "pop3";

	/**
	 * ǥեȤΥݡȡ-1<br>
	 * -1ϥץȥ˱ŬڤʥݡȤꤹ̤͡
	 */
	public static final int DEFAULT_PORT = -1;

	private static final String INBOX_NAME = "INBOX";

	private String host = DEFAULT_HOST;

	private String protocol = DEFAULT_PROTOCOL;

	private int port = DEFAULT_PORT;

	private String username;

	private String password;

	private boolean javaMailLogEnabled;

	private Store store;

	private Folder currentFolder;

	/**
	 * 󥹥ȥ饯
	 */
	public FetchMailProImpl() {}

	/**
	 * @see com.ozacc.mail.fetch.FetchMailPro#connect()
	 */
	public synchronized void connect() throws MailException {
		log.debug(protocol.toUpperCase() + "[" + host + "]³ޤ");

		Session session = Session.getInstance(createProperties(), null);
		if (javaMailLogEnabled) {
			session.setDebug(true);
		}

		try {
			store = session.getStore(protocol);
		} catch (NoSuchProviderException e) {
			log.error("ꤵ줿ץȥ[" + protocol + "]ϥݡȤƤޤ", e);
			throw new MailException("ꤵ줿ץȥ[" + protocol + "]ϥݡȤƤޤ", e);
		}

		try {
			store.connect(host, port, username, password);
		} catch (AuthenticationFailedException e) {
			log.error(protocol.toUpperCase() + "[" + host + "]ؤ³ǧڤ˼Ԥޤ", e);
			throw new MailAuthenticationException(protocol.toUpperCase() + "[" + host
					+ "]ؤ³ǧڤ˼Ԥޤ", e);
		} catch (MessagingException e) {
			log.error(protocol.toUpperCase() + "[" + host + "]ؤ³˼Ԥޤ", e);
			throw new MailException(protocol.toUpperCase() + "[" + host + "]ؤ³˼Ԥޤ", e);
		}

		log.info(protocol.toUpperCase() + "[" + host + "]³ޤ");

		changeFolder(INBOX_NAME);
	}

	/**
	 * SessionϤProperties󥹥󥹤֤ޤ
	 * APOPǧڤԤˡ"mail.pop3.apop.enable"򥻥åȤޤ
	 * 
	 * @return SessionϤProperties󥹥
	 */
	private Properties createProperties() {
		Properties prop = new Properties();
		if ("apop".equalsIgnoreCase(protocol)) {
			prop.put("mail.pop3.apop.enable", "true");
		}
		return prop;
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMailPro#disconnect()
	 */
	public synchronized void disconnect() throws MailException {
		closeCurrentFolderIfOpen();
		log.debug(protocol.toUpperCase() + "[" + host + "]Ȥ³Ǥޤ");
		try {
			store.close();
			store = null;
		} catch (MessagingException e) {
			throw new MailException("[" + host + "]Ȥ³Ǥ˼Ԥޤ", e);
		}
		log.info(protocol.toUpperCase() + "[" + host + "]Ȥ³Ǥޤ");
	}

	/**
	 * ߤΥåե򥯥ޤ
	 * 
	 * @throws MailException åեΥ˼Ԥ
	 */
	private void closeCurrentFolderIfOpen() throws MailException {
		if (currentFolder != null && currentFolder.isOpen()) {
			log.debug("åե[" + currentFolder.getName() + "]򥯥ޤ");
			try {
				currentFolder.close(true);
			} catch (MessagingException e) {
				log.error("åե[" + currentFolder.getName() + "]Υ˼Ԥޤ", e);
				throw new MailException("åե[" + currentFolder.getName() + "]Υ˼Ԥޤ",
						e);
			}
			log.debug("åե[" + currentFolder.getName() + "]򥯥ޤ");
			currentFolder = null;
		}
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMailPro#changeFolder(java.lang.String)
	 */
	public synchronized void changeFolder(String folderName) throws MailException {
		closeCurrentFolderIfOpen();

		log.debug("åե[" + folderName + "]򥪡ץ󤷤ޤ");
		try {
			currentFolder = store.getFolder(folderName);
			currentFolder.open(Folder.READ_WRITE);
		} catch (MessagingException e) {
			log.error("åե[" + folderName + "]Υץ˼Ԥޤ", e);
			throw new MailException("åե[" + folderName + "]Υץ˼Ԥޤ", e);
		}
		log.debug("åե[" + folderName + "]򥪡ץ󤷤ޤ");
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMailPro#getMailCount()
	 */
	public int getMailCount() throws MailException {
		checkIfCurrentFolderIsOpen();
		try {
			return currentFolder.getMessageCount();
		} catch (MessagingException e) {
			throw new MailFetchException("᡼μ˼Ԥޤ", e);
		}
	}

	/**
	 * ᡼륵Ф³ƤơեǤ֤ɤĴ٤ޤ
	 * եǤ֤ˤʤ硢NotConnectedException򥹥ޤ
	 * 
	 * @throws NotConnectedException
	 */
	private void checkIfCurrentFolderIsOpen() throws NotConnectedException {
		if (currentFolder == null || !currentFolder.isOpen()) {
			throw new NotConnectedException(protocol.toUpperCase() + "[" + host + "]³Ƥޤ");
		}
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMailPro#getMail(int)
	 */
	public ReceivedMail getMail(int num) throws MailException {
		MimeMessage mimeMessage = getMessage(num);
		MailConverter converter = new MailConverter(mimeMessage);
		return converter.convertIntoMails()[0];
	}

	public ReceivedMail[] getMails(boolean delete) throws MailException {
		MimeMessage[] mimeMessages = getMessages(delete);
		MailConverter converter = new MailConverter(mimeMessages);
		return converter.convertIntoMails();
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMailPro#getMessage(int)
	 */
	public MimeMessage getMessage(int num) throws MailException {
		checkIfCurrentFolderIsOpen();
		try {
			return (MimeMessage)currentFolder.getMessage(num);
		} catch (MessagingException e) {
			log.error("åμ˼Ԥޤ", e);
			throw new MailFetchException("åμ˼Ԥޤ", e);
		}
	}

	public MimeMessage[] getMessages(boolean delete) throws MailException {
		checkIfCurrentFolderIsOpen();
		try {
			Message[] messages = currentFolder.getMessages();

			if (log.isInfoEnabled()) {
				if (messages.length > 0) {
					log.info(messages.length + "̤Υ᡼ޤ");
				} else {
					log.info("᡼Ϥޤ");
				}
			}

			// SEENե饰ΩƤ
			currentFolder.setFlags(messages, new Flags(Flags.Flag.SEEN), true);

			// DELETEDե饰ΩƤ
			if (delete) {
				currentFolder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
			}

			MimeMessage[] mimeMessages = new MimeMessage[messages.length];
			for (int i = 0; i < messages.length; i++) {
				mimeMessages[i] = (MimeMessage)messages[i];

			}
			return mimeMessages;
		} catch (MessagingException e) {
			log.error("åμ˼Ԥޤ", e);
			throw new MailFetchException("åμ˼Ԥޤ", e);
		}
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMailPro#isConnected()
	 */
	public boolean isConnected() {
		return store.isConnected();
	}

	/**
	 * @return Returns the host.
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param host The host to set.
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return ǧڥѥ
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param password ǧڥѥ
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return ץȥ
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * ᡼˻Ѥץȥ򥻥åȤޤ
	 * ߥݡȤƤץȥϡpop3פȡimapפĤǤ
	 * ǥեȤϡpop3פǤ
	 * <p>
	 * POP3ФؤǧڤAPOPǹԤϡץȥ̾ǤϤޤ󤬡
	 * apopפꤷƤAPOPǧڤѤˤϡJavaMail 1.3.2ʹߤɬפǤ
	 * 
	 * @param protocol ץȥ
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * @return ǧڥ桼̾
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param username ǧڥ桼̾
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * @return ݡֹ
	 */
	public int getPort() {
		return port;
	}

	/**
	 * ᡼˻Ѥݡֹ򥻥åȤޤ
	 * ץȥ˱ݡֹ椬ưŪ˻ѤޤΤǡ̾盧ǥݡֹ򥻥åȤɬפϤޤ
	 * 
	 * @param port ݡֹ
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * JavaMailΥǥХåͭɤȽꤷޤ
	 * 
	 * @return JavaMailΥǥХåͭʾ ture
	 */
	public boolean isJavaMailLogEnabled() {
		return javaMailLogEnabled;
	}

	/**
	 * JavaMailΥǥХåͭˤ뤫ɤꤷޤ
	 * ͭˤȡ<code>System.out</code>ΥǥХååϤޤ<br>
	 * ǥեȤ̵ˤʤäƤޤ
	 * 
	 * @see javax.mail.session#setDebug(boolean)
	 * @param javaMailLogEnabled The javaMailLogEnabled to set.
	 */
	public void setJavaMailLogEnabled(boolean javaMailLogEnabled) {
		this.javaMailLogEnabled = javaMailLogEnabled;
	}
}