package com.ozacc.mail.fetch.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.mail.fetch.ReceivedMail;
import com.ozacc.mail.fetch.impl.sk_jp.AttachmentsExtractor;
import com.ozacc.mail.fetch.impl.sk_jp.HtmlPartExtractor;
import com.ozacc.mail.fetch.impl.sk_jp.MultipartUtility;

/**
 * MimeMessageMail륯饹
 * <p>
 * Ѵå㳰ϡΥ饹ǥå̵뤵ޤ
 * 㳰(пͤ䰸ʤ)˳Mail󥹥󥹤Υץѥƥˤϲ⥻åȤޤ
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: MailConverter.java,v 1.1.2.8 2005/01/18 07:21:20 otsuka Exp $
 */
public class MailConverter {

	private static Log log = LogFactory.getLog(MailConverter.class);

	private MimeMessage[] messages;

	/**
	 * @param mimeMessage 
	 */
	public MailConverter(MimeMessage mimeMessage) {
		this(new MimeMessage[] { mimeMessage });
	}

	/**
	 * @param mimeMessages 
	 */
	public MailConverter(MimeMessage[] mimeMessages) {
		this.messages = mimeMessages;
	}

	/**
	 * @return
	 */
	public ReceivedMail[] convertIntoMails() {
		log.debug("" + messages.length + "̤MimeMessageMailѴޤ");
		List list = new ArrayList();
		for (int i = 0; i < messages.length; i++) {
			log.debug((i + 1) + "ܤMimeMessageMailѴޤ");

			MimeMessage mm = messages[i];
			ReceivedMail mail = new ReceivedMail();

			setReturnPath(mm, mail);
			setDate(mm, mail);
			setFromAddress(mm, mail);
			setRecipientAddresses(mm, mail);
			setMessageId(mm, mail);
			setReplyToAddress(mm, mail);
			setSubject(mm, mail);
			setXHeaders(mm, mail);
			setText(mm, mail);
			setHtmlText(mm, mail);
			setAttachmentFiles(mm, mail);

			setSize(mm, mail);

			mail.setMessage(mm);

			log.debug((i + 1) + "ܤMimeMessageMailѴޤ");
			log.debug(mail.toString());

			list.add(mail);
		}
		log.debug("" + messages.length + "̤MimeMessageMailѴޤ");
		return (ReceivedMail[])list.toArray(new ReceivedMail[list.size()]);
	}

	/**
	 * ꤵ줿MimeMessageźդƤեФ
	 * ꤵ줿ReceivedMail˥åȤޤ
	 * 
	 * @param mm
	 * @param mail 
	 */
	private void setAttachmentFiles(MimeMessage mm, ReceivedMail mail) {
		try {
			AttachmentsExtractor ae = new AttachmentsExtractor(
					AttachmentsExtractor.MODE_IGNORE_MESSAGE
							| AttachmentsExtractor.MODE_IGNORE_INLINE);
			MultipartUtility.process(mm, ae);
			for (int i = 0, num = ae.getCount(); i < num; i++) {
				String fileName = ae.getFileName(i);
				InputStream is = ae.getInputStream(i);
				mail.addFile(is, fileName);
			}
		} catch (IOException e) {
			log.error("źեեμ˼Ԥޤ", e);
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
	}

	private void setXHeaders(MimeMessage mm, ReceivedMail mail) {
		log.debug("X-HeaderMail˥åȤޤ");
		String[] xHeaders = null;
		Enumeration headerEnum = null;
		try {
			headerEnum = mm.getAllHeaders();
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
		while (headerEnum != null && headerEnum.hasMoreElements()) {
			Header header = (Header)headerEnum.nextElement();
			if (header.getName().startsWith("X-")) {
				mail.addXHeader(header.getName(), header.getValue());
			}
		}
	}

	private void setReplyToAddress(MimeMessage mm, ReceivedMail mail) {
		log.debug("Reply-Toɥ쥹Mail˥åȤޤ");
		Address[] addresses = null;
		try {
			addresses = mm.getReplyTo();
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
		if (addresses != null) {
			log.debug(addresses.length + "ĤReply-Toɥ쥹ĤޤǽΥɥ쥹Τ߼ޤ");
			for (int j = 0; j < addresses.length; j++) {
				Address address = addresses[j];
				mail.setReplyTo((InternetAddress)address);
				break;
			}
		} else {
			log.debug("Reply-Toɥ쥹ϸĤޤǤ");
		}
	}

	/**
	 * ᡼(byte)MimeMessageReceivedMail˥åȤޤ
	 * ˼Ԥ -1 򥻥åȤޤ
	 * 
	 * @param mm
	 * @param mail 
	 */
	private void setSize(MimeMessage mm, ReceivedMail mail) {
		try {
			mail.setSize(mm.getSize());
		} catch (MessagingException e) {
			mail.setSize(-1);
		}
	}

	/**
	 * @param mm
	 * @param mail
	 * @throws MessagingException 
	 */
	private void setHtmlText(MimeMessage mm, ReceivedMail mail) {
		try {
			HtmlPartExtractor hpe = new HtmlPartExtractor();
			MultipartUtility.process(mm, hpe);
			String htmlText = hpe.getHtml();
			mail.setHtmlText(htmlText);
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
	}

	private void setText(MimeMessage mm, ReceivedMail mail) {
		try {
			String text = MultipartUtility.getPlainText(mm);
			mail.setText(text);
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
	}

	private void setMessageId(MimeMessage mm, ReceivedMail mail) {
		try {
			String messageId = mm.getMessageID();
			mail.setMessageId(messageId);
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
	}

	private void setSubject(MimeMessage mm, ReceivedMail mail) {
		try {
			String subject = mm.getSubject();
			mail.setSubject(subject);
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
	}

	private void setDate(MimeMessage mm, ReceivedMail mail) {
		try {
			Date d = mm.getSentDate();
			mail.setDate(d);
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
	}

	/**
	 * Return-Pathɥ쥹ɬ⥻åȤƤϤޤ
	 * äspamϤΥ᡼ǤʥեޥåȤΥ᡼륢ɥ쥹
	 * åȤƤ⤢Τա
	 * 
	 * @param mm
	 * @param mail
	 */
	private void setReturnPath(MimeMessage mm, ReceivedMail mail) {
		log.debug("Return-Pathɥ쥹򸡽Фޤ");
		String[] returnPath = null;
		try {
			returnPath = mm.getHeader("Return-Path");
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
		if (returnPath != null && returnPath.length > 0) {
			String email = returnPath[0].substring(1, returnPath[0].length() - 1);
			if (email.length() > 0) {
				try {
					mail.setReturnPath(email);
					log.debug("Return-Pathɥ쥹Mail˥åȤޤ[Return-Path='" + email + "']");
				} catch (IllegalArgumentException e) {
					log.warn("Return-Pathɥ쥹ʥ᡼륢ɥ쥹եޥåȤǤ[Return-Path='" + email + "']");
				}
			} else {
				log.debug("Return-Pathɥ쥹ϸĤޤǤ");
			}
		} else {
			log.debug("Return-Pathɥ쥹ϸĤޤǤ");
		}
	}

	private void setFromAddress(MimeMessage mm, ReceivedMail mail) {
		log.debug("Fromɥ쥹򸡽Фޤ");
		Address[] addresses = null;
		try {
			addresses = mm.getFrom();
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
		if (addresses != null) {
			log.debug(addresses.length + "ĤFromɥ쥹Ĥޤ");
			for (int j = 0; j < addresses.length; j++) {
				InternetAddress address = (InternetAddress)addresses[j];
				mail.setFrom(address);
				log.debug("Fromɥ쥹Mail˥åȤޤ[From='" + address.toUnicodeString() + "']");
			}
		} else {
			log.debug("Fromɥ쥹ϸĤޤǤ");
		}
	}

	private void setRecipientAddresses(MimeMessage mm, ReceivedMail mail) {
		/*
		 * TOɥ쥹Υѡ
		 */
		log.debug("Toɥ쥹򸡽Фޤ");
		Address[] toAddresses = null;
		try {
			toAddresses = mm.getRecipients(Message.RecipientType.TO);
		} catch (AddressException e) {
			log.warn("ʥ᡼륢ɥ쥹Фޤ[" + e.getRef() + "]");
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
		if (toAddresses != null) {
			log.debug(toAddresses.length + "ĤToɥ쥹Ĥޤ");
			for (int j = 0; j < toAddresses.length; j++) {
				InternetAddress address = (InternetAddress)toAddresses[j];
				mail.addTo(address);
				log.debug("Toɥ쥹Mail˥åȤޤ[To='" + address.toUnicodeString() + "']");
			}
		} else {
			log.debug("Toɥ쥹ϸĤޤǤ");
		}

		/*
		 * CCɥ쥹Υѡ
		 */
		log.debug("Ccɥ쥹򸡽Фޤ");
		Address[] ccAddresses = null;
		try {
			ccAddresses = mm.getRecipients(Message.RecipientType.CC);
		} catch (AddressException e) {
			log.warn("ʥ᡼륢ɥ쥹Фޤ[" + e.getRef() + "]");
		} catch (MessagingException e) {
			// ignore
			log.warn(e.getMessage());
		}
		if (ccAddresses != null) {
			log.debug(ccAddresses.length + "ĤCcɥ쥹Ĥޤ");
			for (int j = 0; j < ccAddresses.length; j++) {
				InternetAddress address = (InternetAddress)ccAddresses[j];
				mail.addCc(address);
				log.debug("Ccɥ쥹Mail˥åȤޤ[Cc='" + address.toUnicodeString() + "']");
			}
		} else {
			log.debug("Ccɥ쥹ϸĤޤǤ");
		}
	}

}