/*
 * @(#) $Id: FromCP932Corrector.java,v 1.1.2.1 2005/01/18 07:20:36 otsuka Exp $
 * $Revision: 1.1.2.1 $
 * Copyright (c) 2000 Shin Kinoshita All Rights Reserved.
 */
package com.ozacc.mail.fetch.impl.sk_jp.io;

/**
 * FromCP932Corrector.
 * <p>
 * CorrectOutputStreamWriterѤʸХåե饹Ǥ<br>
 * ְΤJavaHouse-BrewersƵ[14452]Cp932饹
 * Ѵɽ򻲹ͤˤƤƤޤ<br>
 * </p>
 * @version $Revision: 1.1.2.1 $ $Date: 2005/01/18 07:20:36 $
 * @author Shin
 */
public class FromCP932Corrector extends UnicodeCorrector {
    /**
     * UnicodeʸԤޤ
     * <p>
     * "MS932""Shift_JIS"󥳡ǥ󥰰ʳǽϤ褦Ȥݤ
     * sun.iocom.msСǤѴǤʤʬޤ
     * </p>
     * @param  c     source character
     * @return Result character that corrected.
     */
    public char correct(char c) {
        switch (c) {
            // ISO-2022-JPСᤷƤ褦
//          case 0xff3c:        // FULLWIDTH REVERSE SOLIDUS ->
//              return 0x005c;  // REVERSE SOLIDUS
            case 0xff5e:        // FULLWIDTH TILDE ->
                return 0x301c;  // WAVE DASH
            case 0x2225:        // PARALLEL TO ->
                return 0x2016;  // DOUBLE VERTICAL LINE
            case 0xff0d:        // FULLWIDTH HYPHEN-MINUS ->
                return 0x2212;  // MINUS SIGN
            case 0xffe0:        // FULLWIDTH CENT SIGN ->
                return 0x00a2;  // CENT SIGN
            case 0xffe1:        // FULLWIDTH POUND SIGN ->
                return 0x00a3;  // POUND SIGN
            case 0xffe2:        // FULLWIDTH NOT SIGN ->
                return 0x00ac;  // NOT SIGN
        }
        return c;
    }
}
