/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.impl.DTDEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractXMLMailBuilder {
    protected Map documentBuilderCache = new HashMap();

    protected synchronized Document getDocumentFromFile(File file, boolean ignoreComment) throws SAXException, IOException {
        DocumentBuilder db = this.createDocumentBuilder(ignoreComment);
        return db.parse(file);
    }

    protected Document getDocumentFromFile(File file) throws SAXException, IOException {
        return this.getDocumentFromFile(file, true);
    }

    protected DocumentBuilder createDocumentBuilder(boolean ignoreComment) throws FactoryConfigurationError {
        Boolean dbKey = ignoreComment;
        DocumentBuilder db = (DocumentBuilder)this.documentBuilderCache.get(dbKey);
        if (db == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(ignoreComment);
            dbf.setCoalescing(ignoreComment);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setValidating(true);
            try {
                db = dbf.newDocumentBuilder();
                db.setEntityResolver(new DTDEntityResolver());
                this.documentBuilderCache.put(dbKey, db);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return db;
    }

    protected DocumentBuilder createDocumentBuilder() throws FactoryConfigurationError {
        return this.createDocumentBuilder(true);
    }

    protected synchronized Document getDocumentFromClassPath(String classPath, boolean ignoreComment) throws SAXException, IOException {
        Document document;
        block2: {
            InputStream is = this.getClass().getResourceAsStream(classPath);
            DocumentBuilder db = this.createDocumentBuilder(ignoreComment);
            try {
                document = db.parse(is);
                Object var5_6 = null;
                if (is == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_7 = null;
                    if (is == null) break block3;
                    is.close();
                }
                throw throwable;
            }
            is.close();
        }
        return document;
    }

    protected Document getDocumentFromClassPath(String classPath) throws SAXException, IOException {
        return this.getDocumentFromClassPath(classPath, true);
    }

    protected void setReplyTo(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("replyTo");
        Element replyTo = (Element)nodes.item(0);
        if (replyTo != null && replyTo.getAttribute("email").length() > 0) {
            mail.setReplyTo(replyTo.getAttribute("email"));
        }
    }

    protected void setText(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("body");
        Element bodyElem = (Element)nodes.item(0);
        if (bodyElem == null) {
            return;
        }
        String body = bodyElem.getFirstChild().getNodeValue();
        mail.setText(body.trim());
    }

    protected void setHtml(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("html");
        Element htmlElem = (Element)nodes.item(0);
        if (htmlElem == null) {
            return;
        }
        String html = htmlElem.getFirstChild().getNodeValue();
        mail.setHtmlText(html.trim());
    }

    protected void setSubject(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("subject");
        Element subjectElem = (Element)nodes.item(0);
        if (subjectElem == null) {
            return;
        }
        String subject = subjectElem.getFirstChild().getNodeValue();
        mail.setSubject(subject.trim());
    }

    protected void setRecipients(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("recipients");
        Element recipientsElem = (Element)nodes.item(0);
        if (recipientsElem == null) {
            return;
        }
        NodeList recipientElemList = recipientsElem.getChildNodes();
        int i = 0;
        int max = recipientElemList.getLength();
        while (i < max) {
            Node node = recipientElemList.item(i);
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                if ("to".equals(e.getNodeName())) {
                    if (e.getAttribute("email").length() > 0) {
                        if (e.getAttribute("name").length() > 0) {
                            mail.addTo(e.getAttribute("email"), e.getAttribute("name"));
                        } else {
                            mail.addTo(e.getAttribute("email"));
                        }
                    }
                } else if ("cc".equals(e.getNodeName())) {
                    if (e.getAttribute("email").length() > 0) {
                        if (e.getAttribute("name").length() > 0) {
                            mail.addCc(e.getAttribute("email"), e.getAttribute("name"));
                        } else {
                            mail.addCc(e.getAttribute("email"));
                        }
                    }
                } else if (e.getAttribute("email").length() > 0) {
                    mail.addBcc(e.getAttribute("email"));
                }
            }
            ++i;
        }
    }

    protected void setReturnPath(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("returnPath");
        Element returnPath = (Element)nodes.item(0);
        if (returnPath != null && returnPath.getAttribute("email").length() > 0) {
            mail.setReturnPath(returnPath.getAttribute("email"));
        }
    }

    protected void setFrom(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("from");
        Element from = (Element)nodes.item(0);
        if (from != null && from.getAttribute("email").length() > 0) {
            if (from.getAttribute("name").length() > 0) {
                mail.setFrom(from.getAttribute("email"), from.getAttribute("name"));
            } else {
                mail.setFrom(from.getAttribute("email"));
            }
        }
    }
}

