/*
 * @(#) $Id: MailUtility.java,v 1.1.2.1 2005/01/18 07:20:59 otsuka Exp $
 * Copyright (c) 2000-2004 Shin Kinoshita All Rights Reserved.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;

import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

import com.ozacc.mail.fetch.impl.sk_jp.io.CharCodeConverter;
import com.ozacc.mail.fetch.impl.sk_jp.io.UnicodeCorrector;
import com.ozacc.mail.fetch.impl.sk_jp.text.EntityRefEncoder;
import com.ozacc.mail.fetch.impl.sk_jp.util.StringValues;
import com.sun.mail.util.BASE64EncoderStream;

/**
 * JavaMailΥݡȥ饹Ǥ
 * <P>
 * ˥إåФ뤵ޤޤʲùǽ󶡤ޤ
 * </P>
 * @author Shin
 * @version $Revision: 1.1.2.1 $ $Date: 2005/01/18 07:20:59 $
 */
public class MailUtility {

	public static String getPersonal(InternetAddress a) {
		if (a.getPersonal() != null)
			return a.getPersonal();
		return a.toString();
	}

	/** get comma separated E-Mail addresses. */
	public static String getMailAddresses(InternetAddress[] addresses) {
		if (addresses == null)
			return null;
		StringValues buf = new StringValues();
		for (int i = 0; i < addresses.length; i++) {
			buf.add(addresses[i].getAddress());
		}
		return buf.getString();
	}

	/** get comma separated personal names. */
	public static String getPersonalNames(InternetAddress[] addresses) {
		if (addresses == null)
			return null;
		StringValues buf = new StringValues();
		String name;
		for (int i = 0; i < addresses.length; i++) {
			name = decodeText(unfold(addresses[i].getPersonal()));
			if (name == null) {
				name = addresses[i].toString();
			}
			buf.add(name);
		}
		return buf.getString();
	}

	public static String getAddressesHTML(InternetAddress[] addresses) {
		if (addresses == null)
			return null;
		StringValues buf = new StringValues();
		StringBuffer href = new StringBuffer();
		String name;
		for (int i = 0; i < addresses.length; i++) {
			href.append("<a href=\"mailto:");
			href.append(addresses[i].getAddress());
			href.append("\">");
			name = addresses[i].getPersonal();
			if (name != null) {
				name = decodeText(name);
			}
			if (name == null) {
				name = addresses[i].toString();
			}
			href.append(EntityRefEncoder.encode(name));
			href.append("</a>");
			buf.add(new String(href));
			href.setLength(0);
		}
		return buf.getString();
	}

	/** get the Content-Transfer-Encoding: header value. */
	public static String getTransferEncoding(byte[] b) {
		int nonAscii = 0;
		for (int i = 0; i < b.length; i++) {
			if (b[i] < 0) {
				nonAscii++;
			}
		}
		if (nonAscii == 0)
			return "7bit";
		if (nonAscii < b.length - nonAscii)
			return "quoted-printable";
		return "base64";
	}

	/**
	 * ѡȤͭMessage֥Ȥ֤ޤ
	 * @param part ѡ
	 * @return ĥ꡼¤κǾ̤ˤå֥
	 */
	public static Message getParentMessage(Part part) {
		Part current = part;
		Multipart mp;
		while (!(current instanceof Message)) {
			mp = ((BodyPart)current).getParent();
			if (mp == null)
				return null; // Should it throw exception?
			current = mp.getParent();
			if (current == null)
				return null; // Should it throw exception?
		}
		return (Message)current;
	}

	//////////////////////////////////////////////////////////////////////////
	// note: JavaMail1.2 later
	private static MailDateFormat mailDateFormat = new MailDateFormat();

	/**
	 * Dateʸθä"JST"ॾԤޤ
	 * <P>
	 * JavaMail"JST"ȵҤ륿ॾᤷޤ "+0900"ǤʤФʤʤȤǤ <BR>
	 * ʤΤ" JST"ޤޤʸξ"+0900"䴰
	 * MailDateFormat#parse()̤褦parse()ΥåѤѰդޤ
	 * </P>
	 * <P>
	 * μϰŪʤΤǤꡢʤΤǤϤޤ
	 * </P>
	 */
	public static Date parseDate(String rfc822DateString) {
		if (rfc822DateString == null) {
			return null;
		}
		try {
			if (rfc822DateString.indexOf(" JST") == -1 || rfc822DateString.indexOf('+') >= 0) {
				synchronized (mailDateFormat) {
					return mailDateFormat.parse(rfc822DateString);
				}
			}
			// correct the pseudo header
			StringBuffer buf = new StringBuffer(rfc822DateString.substring(0, rfc822DateString
					.indexOf("JST")));
			buf.append("+0900");
			synchronized (mailDateFormat) {
				return mailDateFormat.parse(new String(buf));
			}
		} catch (java.text.ParseException e) {
			return null;
		}
	}

	//////////////////////////////////////////////////////////////////////////
	/**
	 * Subject:"Re: "ղäޤ
	 * <P>
	 * ٴƤ"Re: "˶ᤤʸ"[hoge]"ޤ <BR>
	 * տޤʤʬäƤޤ⤢ޤ <BR>
	 * JavaMailreply()Ǥ"Re: "󥳡ɤƤ "Re: "Ƥޤ
	 * </P>
	 */
	public static String createReplySubject(String src) {
		if (src == null || src.length() == 0) {
			return "Re: (no subject)";
		}
		String work = src;
		if (work.charAt(0) == '[' && work.indexOf(']') > 0) {
			int afterBracket = indexOfNonLWSP(work, work.indexOf(']') + 1, false);
			if (afterBracket < 0) {
				work = "";
			} else {
				work = work.substring(afterBracket);
			}
		}
		if (work.length() > 3 && "Re:".equalsIgnoreCase(work.substring(0, 3))) {
			int afterRe = indexOfNonLWSP(work, 3, false);
			if (afterRe < 0) {
				work = "";
			} else {
				work = work.substring(afterRe);
			}
		}
		return "Re: " + work;
	}

	//////////////////////////////////////////////////////////////////////////
	/**
	 * Ϥ줿ɥ쥹InternetAddressѴޤ
	 * <p>
	 * "̵̾ <abc@example.com>()"ʸ(󥳡̵)
	 * ϤƤ⡢personalʸꤵ褦ˤޤ <br>
	 * InternetAddress#parse()ϥ󥳡ɺѤߤʸˤƤ뤿ᡢ Υ᥽åɤŪˤϱ褤ޤ
	 * </p>
	 * @param addresses ᥤ륢ɥ쥹ʸ(޶ڤ)
	 */
	public static InternetAddress[] parseAddresses(String addressesString) throws AddressException {
		return parseAddresses(addressesString, true);
	}

	public static InternetAddress[] parseAddresses(String addressesString, boolean strict)
																							throws AddressException {
		if (addressesString == null)
			return null;
		try {
			InternetAddress[] addresses = InternetAddress.parse(addressesString, strict);
			// correct personals
			for (int i = 0; i < addresses.length; i++) {
				addresses[i].setPersonal(addresses[i].getPersonal(), "ISO-2022-JP");
			}
			return addresses;
		} catch (UnsupportedEncodingException e) {
			throw new InternalError(e.toString());
		}
	}

	// InternetAddress.parse(
	//          encodeText(addressesString, "ISO-2022-JP", "B"), strict);
	// ɤʤΤǤϡʤ꤬äϤ
	//////////////////////////////////////////////////////////////////////////
	/**
	 * header value unfolding Ԥޤ ̩˰ˤ decodeText ˸ƤӽФɬפޤ
	 */
	public static String unfold(String source) {
		if (source == null)
			return null;
		StringBuffer buf = new StringBuffer();
		boolean skip = false;
		char c;
		// <CRLF>󥹤ȤʤindexOf()ǽʬǤ
		// ǰΤCRLFƤޤ
		for (int i = 0; i < source.length(); i++) {
			c = source.charAt(i);
			if (skip) {
				if (isLWSP(c)) {
					continue;
				}
				skip = false;
			}
			if (c != '\r' && c != '\n') {
				buf.append(c);
			} else {
				buf.append(' ');
				skip = true;
			}
		}
		return new String(buf);
	}

	/**
	 * header value folding Ԥޤ
	 * <P>
	 * white spacefoldingоݤˤޤ <BR>
	 * 76bytesĶʤwhite space֤ <CRLF>ޤ
	 * </P>
	 * <P>
	 * :quote̵뤷ޤΤǡstructured fieldǤԹ礬 ȯǽޤ
	 * </P>
	 * @param used إå':'ޤǤʸ76 - usedǽfolding
	 * @return folding줿( <CRLF>SPACE줿)ʸ
	 */
	public static String fold(String source, int used) {
		if (source == null)
			return null;
		StringBuffer buf = new StringBuffer();
		String work = source;
		int lineBreakIndex;
		while (work.length() > 76) {
			lineBreakIndex = work.lastIndexOf(' ', 76);
			if (lineBreakIndex == -1)
				break;
			buf.append(work.substring(0, lineBreakIndex));
			buf.append("\r\n");
			work = work.substring(lineBreakIndex);
		}
		buf.append(work);
		return new String(buf);
	}

	//////////////////////////////////////////////////////////////////////////
	/**
	 * ѡȤ˥ƥȤ򥻥åȤޤ
	 * Part#setText() ˤȤȤǡ
	 * "ISO-2022-JP" СǤϥ󥳡ɤǤʤ CP932 
	 * ʸ򥨥󥳡ɤǤޤ
	 */
	public static void setTextContent(Part p, String s) throws MessagingException {
		//p.setText(content, "ISO-2022-JP");
		p.setDataHandler(new DataHandler(new JISDataSource(s)));
		p.setHeader("Content-Transfer-Encoding", "7bit");
	}

	/**
	 * ܸޤإåѥƥȤޤ
	 * Ѵ̤ ASCII ʤΤǡ򤽤Τޤ setSubject  InternetAddress
	 * Υѥ᥿ȤƻѤƤ
	 * "ISO-2022-JP" СǤϥ󥳡ɤǤʤ CP932 
	 * ʸ򥨥󥳡ɤǤޤencodeText() Ȱۤʤꡢ
	 * folding ΰռ򤷤Ƥ餺ޤ ASCII ʬʬ
	 * 󥳡ɤԤȤǤޤ
	 */
	public static String encodeWordJIS(String s) {
		try {
			return "=?ISO-2022-JP?B?"
					+ new String(BASE64EncoderStream.encode(CharCodeConverter
							.sjisToJis(UnicodeCorrector.getInstance("Windows-31J").correct(s)
									.getBytes("Windows-31J")))) + "?=";
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException("CANT HAPPEN");
		}
	}

	//////////////////////////////////////////////////////////////////////////
	/**
	 * إåʸǥɤޤ
	 * <p>
	 * MimeUtilityˤܤή̤륨󥳡ɷб
	 * ϡencoded-wordnon-encoded-wordδ֤ˤlinear-white-spaceɬ
	 * ʤΤǤ̵ǥ󥳡ɤ륿ᥤ餬¿Τǡ
	 * </p>
	 * <p>
	 * JISɤ򥨥󥳡̵ǵҤ륿ᥤ⤢ޤ <br>
	 * ESCޤޤƤJISȸʤޤ
	 * </p>
	 * <p>
	 * =?utf-8?Q?JISɡ?=ʤƤ˥ʥᥤ⡣ <br>
	 * ˥ǥɸˤޤESCĤäƤISO-2022-JPȸʤȤˤޤ
	 * </p>
	 * <p>
	 * ˡmultibyte character ̤ encoded-word ڤäƤޤ ᥤġܤ
	 * encoded-word  CES ƱϥХ ԤäƤ CES ǥɤԤ褦ˤġ
	 * </p>
	 * <p>
	 * ܸòƤޤͤ
	 * </p>
	 * @param source encoded text
	 * @return decoded text
	 */
	public static String decodeText(String source) {
		if (source == null)
			return null;
		// specially for Japanese
		if (source.indexOf('\u001b') >= 0) {
			// ISO-2022-JP
			try {
				return new String(source.getBytes("ISO-8859-1"), "ISO-2022-JP");
			} catch (UnsupportedEncodingException e) {
				throw new InternalError();
			}
		}
		String decodedText = new RFC2047Decoder(source).get();
		if (decodedText.indexOf('\u001b') >= 0) {
			try {
				return new String(decodedText.getBytes("ISO-8859-1"), "ISO-2022-JP");
			} catch (UnsupportedEncodingException e) {
				throw new InternalError();
			}
		}
		return decodedText;
	}

	// ܸǥɤ꤬Τǡencoded-wordڤФϤ٤ȼ
	// Netscapeʤɤ"()."ʸencoded-wordڤäƤޤJavaMail
	// ΤȤencoded-wordνȽǤʸƤޤ
	// ޤencoded-word ʸǥɤΤٱ䤵ܤ encoded-word
	//  CES Ʊϡ TES ǥɤԤäХ礷Ƥ
	// CES ˽äǥɤԤޥХʸʬǤ sender 뤫顣
	static class RFC2047Decoder {

		private String source;

		private String pooledCES;

		private byte[] pooledBytes;

		private StringBuffer buf;

		private int pos = 0;

		private int startIndex;

		private int endIndex;

		public RFC2047Decoder(String source) {
			this.source = source;
			buf = new StringBuffer(source.length());
			parse();
		}

		private void parse() {
			while (hasEncodedWord()) {
				String work = source.substring(pos, startIndex);
				if (indexOfNonLWSP(work, 0, false) > -1) {
					sweepPooledBytes();
					buf.append(work);
				} // encoded-wordƱΤδ֤LWSPϺ
				parseWord();
			}
			sweepPooledBytes();
			buf.append(source.substring(pos));
		}

		// encoded-word ä硢startIndex/endIndex 򥻥åȤ
		private boolean hasEncodedWord() {
			startIndex = source.indexOf("=?", pos);
			if (startIndex == -1)
				return false;
			endIndex = source.indexOf("?=", startIndex + 2);
			if (endIndex == -1)
				return false;
			//  encoded-word  LWSP äƤϤʤ
			// encoded-word  folding Ƥޤ sender 餷
			// ʲ򥳥Ȥˤ뤳Ȥ encoded-word θǧβǽ
			// ФƤ뤬ǧˤʤΨʾΤ褦 illegal 
			// å¿Τ¾Τ褦
			// thx > YOSI
			//int i = indexOfLWSP(source, startIndex + 2, false, (char)0);
			//if (i >= 0 && i < endIndex)
			//    return false;
			endIndex += 2;
			return true;
		}

		private void parseWord() {
			try {
				int s = startIndex + 2;
				int e = source.indexOf('?', s);
				if (e == endIndex - 2)
					throw new RuntimeException();
				String ces = source.substring(s, e);
				try {
					"".getBytes(ces); // FIXME: check whether supported or not
				} catch (UnsupportedEncodingException ex) {
					ces = "JISAutoDetect";
				}
				s = e + 1;
				e = source.indexOf('?', s);
				if (e == endIndex - 2)
					throw new RuntimeException();
				String tes = source.substring(s, e);
				byte[] bytes = decodeByTES(source.substring(e + 1, endIndex - 2), tes);
				if (ces.equals(pooledCES)) {
					// append bytes
					byte[] w = new byte[pooledBytes.length + bytes.length];
					System.arraycopy(pooledBytes, 0, w, 0, pooledBytes.length);
					System.arraycopy(bytes, 0, w, pooledBytes.length, bytes.length);
					pooledBytes = w;
				} else {
					sweepPooledBytes();
					pooledCES = ces;
					pooledBytes = bytes;
				}
			} catch (Exception ex) {
				ex.printStackTrace();
				// contains RuntimeException
				buf.append(source.substring(startIndex, endIndex));
			}
			pos = endIndex;
		}

		private void sweepPooledBytes() {
			if (pooledBytes == null)
				return;
			try {
				buf.append(new String(pooledBytes, pooledCES));
			} catch (UnsupportedEncodingException e) {
				throw new InternalError("CANT HAPPEN: Illegal encoding = " + pooledCES);
			}
			pooledCES = null;
			pooledBytes = null;
		}

		public String get() {
			return new String(buf);
		}
	}

	private static byte[] decodeByTES(String s, String tes) {
		// ̾濫ʤLWSP ͤ
		int i;
		while ((i = indexOfLWSP(s, 0, false, (char)0)) >= 0)
			s = s.substring(0, i) + s.substring(i + 1);
		if (tes.equalsIgnoreCase("B") && s.length() % 4 != 0) {
			// BASE64DecoderStream Τ˥ѥǥ󥰤Ƥʤ
			// IOException ˤʤΤǡ̵궺
			switch (4 - s.length() % 4) {
				case 1:
					s += '=';
					break;
				case 2:
					s += "==";
					break;
				case 3:
					if (s.charAt(s.length() - 1) != '=')
						s += "===";
					else
						s = s.substring(0, s.length() - 1);
					break;
			}
		}
		try {
			ByteArrayInputStream bis = new ByteArrayInputStream(com.sun.mail.util.ASCIIUtility
					.getBytes(s));
			InputStream is;
			if (tes.equalsIgnoreCase("B"))
				is = new com.sun.mail.util.BASE64DecoderStream(bis);
			else if (tes.equalsIgnoreCase("Q"))
				is = new com.sun.mail.util.QDecoderStream(bis);
			else
				throw new UnsupportedEncodingException(tes);
			int count = bis.available();
			byte[] bytes = new byte[count];
			count = is.read(bytes, 0, count);
			if (count != bytes.length) {
				byte[] w = new byte[count];
				System.arraycopy(bytes, 0, w, 0, count);
				bytes = w;
			}
			return bytes;
		} catch (IOException e) {
			e.printStackTrace();
			throw new RuntimeException("CANT HAPPEN");
		}
	}

	/**
	 * ʸ򥨥󥳡ɤޤ
	 * <p>
	 * MimeUtility(ƤMimeMessage)Ǥϡ1ǤASCIIʸޤޤ
	 * ʸΤ򥨥󥳡ɤƤޤޤ
	 * <br>
	 * Υ᥽åɤǤ϶Ƕڤ줿ϰϤ򥨥󥳡ɤޤ <br>
	 * Subject"Re: "󥳡ɤƤȡʸIn-Reply-To:
	 * References:˥åɤ褦ȤƤ⼺Ԥ뤳Ȥˤʤ
	 * ᡢΥ󥳡Ѥͤ⤤뤫⤷ޤ󡦡
	 * </p>
	 * <p>
	 * ˤϡASCIIζĤޤޤʳ϶ޤ
	 * encoded-wordȤޤ()¦϶̵Ǥ⥨󥳡оݤǤ
	 * </p>
	 * @param source text
	 * @return encoded text
	 */
	// "()" ΰˤꤹư۾˱-_-
	// "()"ʤ̵뤷ƤޤȤ encode 褦ˤФä뤹뤱ɡġ
	public static String encodeText(String source, String charset, String encoding)
																					throws UnsupportedEncodingException {
		if (source == null)
			return null;
		int boundaryIndex;
		int startIndex;
		int endIndex = 0;
		int lastLWSPIndex;
		StringBuffer buf = new StringBuffer();
		while (true) {
			// check the end of ASCII part
			boundaryIndex = indexOfNonAscii(source, endIndex);
			if (boundaryIndex == -1) {
				buf.append(source.substring(endIndex));
				return new String(buf);
			}
			// any LWSP has taken (back track).
			lastLWSPIndex = indexOfLWSP(source, boundaryIndex, true, '(');
			startIndex = indexOfNonLWSP(source, lastLWSPIndex, true) + 1;
			// ASCII part νλ֤ϡ non ASCII ٤
			// Ǥ ASCII ʸζʸ֤ޤ'('μ
			startIndex = (endIndex > startIndex) ? endIndex : startIndex;
			if (startIndex > endIndex) {
				// ASCII part
				buf.append(source.substring(endIndex, startIndex));
				// JavaMailencodeWordfolding뤱ɤencodedWord
				// ФƤΤߡإåΤΤФfoldingϤƤʤ
				if (isLWSP(source.charAt(startIndex))) {
					// folding ˤ ĤݤΤǥå
					buf.append("\r\n ");
					startIndex++;
					// ʤ'('ξ϶ʤΤ folding ʤ
				}
			}
			// any LWSP has taken.
			endIndex = indexOfNonLWSP(source, boundaryIndex, false);
			while ((endIndex = indexOfLWSP(source, endIndex, false, ')')) != -1) {
				endIndex = indexOfNonLWSP(source, endIndex, false);
				int nextBoundary = indexOfLWSP(source, endIndex, false, (char)0);
				if (nextBoundary == -1) {
					if (indexOfNonAscii(source, endIndex) != -1) {
						endIndex = -1;
						break;
					}
				} else {
					int nonAscii = indexOfNonAscii(source, endIndex);
					if (nonAscii != -1 && nonAscii < nextBoundary) {
						endIndex = nextBoundary;
						continue;
					}
				}
				break;
			}
			boolean needFolding = false;
			if (endIndex < 0) {
				endIndex = source.length();
			} else if (isLWSP(source.charAt(endIndex - 1))) {
				// folding ˤ Ĥݤ(ͽ)ʤΤǸ餹
				endIndex--;
				needFolding = true;
			}
			String encodeTargetText = source.substring(startIndex, endIndex);
			buf.append(MimeUtility.encodeWord(encodeTargetText, charset, encoding));
			if (needFolding) {
				// folding ˤ ĤݤΤǥå
				endIndex++;
				buf.append("\r\n ");
			}
		}
	}

	/**
	 * ֤ǽ˸ĤäASCIIʸIndex֤ޤ startIndex ϰϳξ -1 ֤ޤ
	 * (IndexOutOfBoundsException ǤϤʤ)
	 * @param source ʸ
	 * @param startIndex ϰ
	 * @return ФASCIIʸIndexĤʤ-1
	 */
	public static int indexOfNonAscii(String source, int startIndex) {
		for (int i = startIndex; i < source.length(); i++) {
			if (source.charAt(i) > 0x7f) {
				return i;
			}
		}
		return -1;
	}

	/**
	 * ֤ǽ˸ĤäLWSPʳʸIndex֤ޤ startIndex ϰϳξ -1 ֤ޤ
	 * (IndexOutOfBoundsException ǤϤʤ)
	 * @param source ʸ
	 * @param startIndex ϰ
	 * @param decrease trueǸ
	 * @return ФASCIIʸIndexĤʤ-1
	 */
	public static int indexOfNonLWSP(String source, int startIndex, boolean decrease) {
		char c;
		int inc = 1;
		if (decrease)
			inc = -1;
		for (int i = startIndex; i >= 0 && i < source.length(); i += inc) {
			c = source.charAt(i);
			if (!isLWSP(c)) {
				return i;
			}
		}
		return -1;
	}

	/**
	 * ֤ǽ˸ĤäLWSPIndex֤ޤ startIndex ϰϳξ -1 ֤ޤ
	 * (IndexOutOfBoundsException ǤϤʤ)
	 * @param source ʸ
	 * @param startIndex ϰ
	 * @param decrease trueǸ
	 * @param additionalDelimiter LWSPʳ˶ڤȤߤʤʸ(1Τ)
	 * @return ФASCIIʸIndexĤʤ-1
	 */
	public static int indexOfLWSP(String source, int startIndex, boolean decrease,
									char additionalDelimiter) {
		char c;
		int inc = 1;
		if (decrease)
			inc = -1;
		for (int i = startIndex; i >= 0 && i < source.length(); i += inc) {
			c = source.charAt(i);
			if (isLWSP(c) || c == additionalDelimiter) {
				return i;
			}
		}
		return -1;
	}

	public static boolean isLWSP(char c) {
		return c == '\r' || c == '\n' || c == ' ' || c == '\t';
	}

	//////////////////////////////////////////////////////////////////////////
	/**
	 * This method set Content-Disposition: with RFC2231 encoding. It is
	 * required JavaMail1.2.
	 */
	/**
	 * Part#setFileName()ΥޥХбǤǤ JavaMail1.2ǤʤХѥǤޤ
	 */
	public static void setFileName(Part part, String filename, String charset, String lang)
																							throws MessagingException {
		// Set the Content-Disposition "filename" parameter
		ContentDisposition disposition;
		String[] strings = part.getHeader("Content-Disposition");
		if (strings == null || strings.length < 1) {
			disposition = new ContentDisposition(Part.ATTACHMENT);
		} else {
			disposition = new ContentDisposition(strings[0]);
			disposition.getParameterList().remove("filename");
		}
		part.setHeader("Content-Disposition", disposition.toString()
				+ encodeParameter("filename", filename, charset, lang));
		ContentType cType;
		strings = part.getHeader("Content-Type");
		if (strings == null || strings.length < 1) {
			cType = new ContentType(part.getDataHandler().getContentType());
		} else {
			cType = new ContentType(strings[0]);
		}
		try {
			// I want to public the MimeUtility#doEncode()!!!
			String mimeString = MimeUtility.encodeWord(filename, charset, "B");
			// cut <CRLF>...
			StringBuffer sb = new StringBuffer();
			int i;
			while ((i = mimeString.indexOf('\r')) != -1) {
				sb.append(mimeString.substring(0, i));
				mimeString = mimeString.substring(i + 2);
			}
			sb.append(mimeString);
			cType.setParameter("name", new String(sb));
		} catch (UnsupportedEncodingException e) {
			throw new MessagingException("Encoding error", e);
		}
		part.setHeader("Content-Type", cType.toString());
	}

	/**
	 * This method encodes the parameter.
	 * <P>
	 * But most MUA cannot decode the encoded parameters by this method. <BR>
	 * I recommend using the "Content-Type:"'s name parameter both.
	 * </P>
	 */
	/**
	 * إåΥѥ᥿Υ󥳡ɤԤޤ
	 * <P>
	 * ϼǤʤΤ¿ΤǤΥ᥽åɤǤϻȤޤ <BR>
	 * Content-Disposition:filenameΤߤ˻Ѥ Content-Type:nameMIME
	 * encodingǤεҤԤΤǤ礦 <BR>
	 * ѥ᥿ɬƬϤޤΤȤޤ (إåγϹԤޤ֤줿֤򳫻ϰ֤Ȥޤ)
	 * </P>
	 * <P>
	 * foldingˤascii/non asciiΤߤåޤ Ϣ³ascii/non
	 * asciiĹΥåϸԤäƤޤ (󥳡ɸΥХȿǥåʤФʤʤΤǤʤ)
	 * </P>
	 * @param name ѥ᥿̾
	 * @param value 󥳡оݤΥѥ᥿
	 * @param encoding ʸ󥳡ǥ
	 * @param lang 
	 * @return 󥳡ɺѤʸ ";\r\n name*0*=ISO-8859-2'';\r\n name*1*="
	 */
	// 1.Τ򥨥󥳡ɤĹäȾʬڤäƥ󥳡ɤ򷫤֤
	public static String encodeParameter(String name, String value, String encoding, String lang) {
		StringBuffer result = new StringBuffer();
		StringBuffer encodedPart = new StringBuffer();
		boolean needWriteCES = !isAllAscii(value);
		boolean CESWasWritten = false;
		boolean encoded;
		boolean needFolding = false;
		int sequenceNo = 0;
		int column;
		while (value.length() > 0) {
			// index of boundary of ascii/non ascii
			int lastIndex;
			boolean isAscii = value.charAt(0) < 0x80;
			for (lastIndex = 1; lastIndex < value.length(); lastIndex++) {
				if (value.charAt(lastIndex) < 0x80) {
					if (!isAscii)
						break;
				} else {
					if (isAscii)
						break;
				}
			}
			if (lastIndex != value.length())
				needFolding = true;
			RETRY: while (true) {
				encodedPart.setLength(0);
				String target = value.substring(0, lastIndex);
				byte[] bytes;
				try {
					if (isAscii) {
						bytes = target.getBytes("us-ascii");
					} else {
						bytes = target.getBytes(encoding);
					}
				} catch (UnsupportedEncodingException e) {
					bytes = target.getBytes(); // use default encoding
					encoding = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
				}
				encoded = false;
				// It is not strict.
				column = name.length() + 7; // size of " " and "*nn*=" and ";"
				for (int i = 0; i < bytes.length; i++) {
					if ((bytes[i] >= '0' && bytes[i] <= '9')
							|| (bytes[i] >= 'A' && bytes[i] <= 'Z')
							|| (bytes[i] >= 'a' && bytes[i] <= 'z') || bytes[i] == '$'
							|| bytes[i] == '.' || bytes[i] == '!') {
						// 2001/09/01 ٤ʸ沽ʤ꽤
						// attribute-char(沽ʤƤ褤ʸ)
						// <any (US-ASCII) CHAR except SPACE, CTLs,
						// "*", "'", "%", or tspecials>
						// 䤳ΤǱѿΤߤȤƤ
						// "$.!"Ϥޤ^^󥳡ɻ礷ưռϤʤ
						encodedPart.append((char)bytes[i]);
						column++;
					} else {
						encoded = true;
						encodedPart.append('%');
						String hex = Integer.toString(bytes[i] & 0xff, 16);
						if (hex.length() == 1) {
							encodedPart.append('0');
						}
						encodedPart.append(hex);
						column += 3;
					}
					if (column > 76) {
						needFolding = true;
						lastIndex /= 2;
						continue RETRY;
					}
				}
				result.append(";\r\n ").append(name);
				if (needFolding) {
					result.append('*').append(sequenceNo);
					sequenceNo++;
				}
				if (!CESWasWritten && needWriteCES) {
					result.append("*=");
					CESWasWritten = true;
					result.append(encoding).append('\'');
					if (lang != null)
						result.append(lang);
					result.append('\'');
				} else if (encoded) {
					result.append("*=");
					/*
					 * character encodingƬѡȤ˽񤫤ʤȤʤΤ? if (encoded) {
					 * result.append("*="); if (!CESWasWritten && needWriteCES) {
					 * CESWasWritten = true;
					 * result.append(encoding).append('\''); if (lang != null)
					 * result.append(lang); result.append('\''); }
					 */
				} else {
					result.append('=');
				}
				result.append(new String(encodedPart));
				value = value.substring(lastIndex);
				break;
			}
		}
		return new String(result);
	}

	/** check if contains only ascii characters in text. */
	public static boolean isAllAscii(String text) {
		for (int i = 0; i < text.length(); i++) {
			if (text.charAt(i) > 0x7f) { // non-ascii
				return false;
			}
		}
		return true;
	}

	//////////////////////////////////////////////////////////////////////////
	/**
	 * This method decode the RFC2231 encoded filename parameter instead of
	 * Part#getFileName().
	 */
	/**
	 * Part#getFileName()ΥޥХбǤǤ
	 */
	public static String getFileName(Part part) throws MessagingException {
		String[] disposition = part.getHeader("Content-Disposition");
		// A patch by YOSI (Thanx)
		// http://www.sk-jp.com/cgibin/treebbs.cgi?kako=1&all=227&s=227
		String filename;
		if (disposition == null || disposition.length < 1
				|| (filename = getParameter(disposition[0], "filename")) == null) {
			filename = part.getFileName();
			if (filename != null) {
				return decodeParameterSpciallyJapanese(filename);
			}
			return null;
		}
		return filename;
	}

	static class Encoding {

		String encoding = "us-ascii";

		String lang = "";
	}

	/**
	 * This method decodes the parameter which be encoded (folded) by RFC2231
	 * method.
	 * <P>
	 * The parameter's order should be considered.
	 * </P>
	 */
	/**
	 * إåΥѥ᥿ΥǥɤԤޤ
	 * <P>
	 * RFC2231folding(ʬ)줿ѥ᥿礷ǥɤޤ
	 * RFC2231ˤϥѥ᥿ν֤˰¸ʤȽ񤫤Ƥޤ (ʬ䤵줿ƤΥѡȤ
	 * ݻƥȤʤФʤʤ)ʤΤǡ ֹ˴طʤ(0)֤ ¤ǤΤȤߤʤƽ뤳Ȥˤޤ
	 * </P>
	 * @param header إå
	 * @param name ѥ᥿̾
	 * @return ǥɺѤʸ (ѥ᥿¸ߤʤ null)
	 */
	public static String getParameter(String header, String name) throws ParseException {
		if (header == null)
			return null;
		// 褳סܸͭΥǥɽǤ
		// 2001/07/22 ǤǤ".txt"JISѥ᥿ͤǥɤǤʤ
		// ϡISO-2022-JPХΤޤHeaderTokenizerˤȡ
		// ""ΥХȥ󥹤˴ޤޤ0x22֥륯Ȥ
		// ᤵ뤿ᡣ
		// JIS/Shift_JISХȤȻפΤΥǥɤ˹Ԥǲ
		header = decodeParameterSpciallyJapanese(header);
		HeaderTokenizer tokenizer = new HeaderTokenizer(header, ";=\t ", true);
		HeaderTokenizer.Token token;
		StringBuffer sb = new StringBuffer();
		// It is specified in first encoded-part.
		Encoding encoding = new Encoding();
		String n;
		String v;
		try {
			while (true) {
				token = tokenizer.next();
				if (token.getType() == HeaderTokenizer.Token.EOF)
					break;
				if (token.getType() != ';')
					continue;
				token = tokenizer.next();
				checkType(token);
				n = token.getValue();
				token = tokenizer.next();
				if (token.getType() != '=') {
					throw new ParseException("Illegal token : " + token.getValue());
				}
				token = tokenizer.next();
				checkType(token);
				v = token.getValue();
				if (n.equalsIgnoreCase(name)) {
					// It is not divided and is not encoded.
					return v;
				}
				int index = name.length();
				if (!n.startsWith(name) || n.charAt(index) != '*') {
					// another parameter
					continue;
				}
				// be folded, or be encoded
				int lastIndex = n.length() - 1;
				if (n.charAt(lastIndex) == '*') {
					// http://www.sk-jp.com/cgibin/treebbs.cgi?all=399&s=399
					if (index == lastIndex || n.charAt(index + 1) == '0') {
						// decode as initial-section
						sb.append(decodeRFC2231(v, encoding, true));
					} else {
						// decode as other-sections
						sb.append(decodeRFC2231(v, encoding, false));
					}
				} else {
					sb.append(v);
				}
				if (index == lastIndex) {
					// not folding
					break;
				}
			}
			if (sb.length() == 0)
				return null;
			return new String(sb);
		} catch (UnsupportedEncodingException e) {
			throw new ParseException(e.toString());
		}
	}

	private static void checkType(HeaderTokenizer.Token token) throws ParseException {
		int t = token.getType();
		if (t != HeaderTokenizer.Token.ATOM && t != HeaderTokenizer.Token.QUOTEDSTRING) {
			throw new ParseException("Illegal token : " + token.getValue());
		}
	}

	// "lang" tag is ignored...
	private static String decodeRFC2231(String s, Encoding encoding, boolean isInitialSection)
																								throws ParseException,
																								UnsupportedEncodingException {
		StringBuffer sb = new StringBuffer();
		int i = 0;
		if (isInitialSection) {
			int work = s.indexOf('\'');
			if (work > 0) {
				encoding.encoding = s.substring(0, work);
				work++;
				i = s.indexOf('\'', work);
				if (i < 0) {
					throw new ParseException("lang tag area was missing.");
				}
				encoding.lang = s.substring(work, i);
				i++;
			}
		}
		try {
			for (; i < s.length(); i++) {
				if (s.charAt(i) == '%') {
					sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
					i += 2;
					continue;
				}
				sb.append(s.charAt(i));
			}
			return new String(new String(sb).getBytes("ISO-8859-1"), encoding.encoding);
		} catch (IndexOutOfBoundsException e) {
			throw new ParseException(s + " :: this string were not decoded.");
		}
	}

	// ܸǥ
	private static String decodeParameterSpciallyJapanese(String s) throws ParseException {
		try {
			// decode by character encoding.
			// if string are all ASCII, it is not translated.
			s = new String(s.getBytes("ISO-8859-1"), "JISAutoDetect");
			// decode by RFC2047.
			// if string doesn't contain encoded-word, it is not translated.
			return decodeText(s);
		} catch (UnsupportedEncodingException e) {}
		throw new ParseException("Unsupported Encoding");
	}

	private MailUtility() {}
}