/*
 * @(#) $Id: AttachmentsExtractor.java,v 1.1.2.1 2005/01/18 07:20:59 otsuka Exp $
 * Copyright (c) 2000 Shin Kinoshita All Rights Reserved.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;

/**
 * źեեФPartHandlerǤ
 * <p>
 * MultipartUtility#process()ƤӽФgetFileNames()ˤäơ źեե̾뤳ȤǤޤ
 * </p>
 * <p>
 * ե̾indexꤷƤźեեФ
 * InputStreamꡢϤ줿OutputStreamФƽ񤭽ФȤǤޤ
 * </p>
 * @version $Revision: 1.1.2.1 $ $Date: 2005/01/18 07:20:59 $
 * @author Shin
 */
public class AttachmentsExtractor implements PartHandler {

	/** message/*ΥѡȤ̵뤷ޤ */
	public static final int MODE_IGNORE_MESSAGE = 1;

	/** Content-Disposition: inline; ѡȤfilenameäƤ̵뤷ޤ */
	public static final int MODE_IGNORE_INLINE = 2;

	private final int mode;

	private final List attachmentParts = new ArrayList();

	/**
	 * źեե뤿PartHandlerޤ message/*ΥѡȤinlineĥե̾ꤢΥѡȤ
	 * źեեȤưޤ
	 */
	public AttachmentsExtractor() {
		this(0);
	}

	/**
	 * źեե뤿PartHandlerޤ
	 * @param mode ư⡼ɡMODE_ǻϤޤ뼱̻Ҥorꤷޤ
	 */
	public AttachmentsExtractor(int mode) {
		this.mode = mode;
	}

	/** MultipartUtility#process()ƤӤ᥽åɤǤ */
	public boolean processPart(Part part, ContentType context) throws MessagingException,
																IOException {
		if (part.isMimeType("message/*")) {
			if ((mode & MODE_IGNORE_MESSAGE) != 0) {
				return true;
			}
			attachmentParts.add(part);
			return true;
		}
		if (MailUtility.getFileName(part) == null) {
			return true;
		}
		if ((mode & MODE_IGNORE_INLINE) != 0 && Part.INLINE.equalsIgnoreCase(part.getDisposition())) {
			return true;
		}
		attachmentParts.add(part);
		return true;
	}

	/**
	 * źեեĿ֤ޤ
	 */
	public int getCount() {
		return attachmentParts.size();
	}

	/**
	 * źեե֤̾ޤ
	 * <P>
	 * źեե뤬¸ߤʤ϶֤ޤ <BR>
	 * ե̾ƱΤΤʣ¸ߤ⤢ꤨޤ
	 * </P>
	 */
	public String[] getFileNames() throws MessagingException {
		String[] names = new String[getCount()];
		for (int i = 0; i < names.length; i++) {
			names[i] = getFileName(i);
		}
		return names;
	}

	/**
	 * źեեΥե֤̾ޤ
	 */
	public String getFileName(int index) throws MessagingException {
		Part part = (Part)attachmentParts.get(index);
		String name = MailUtility.getFileName(part);
		if (name == null) {
			// źեե̾ǤʤϡꤵƤʤä礫
			// 뤤message/*ΥѡȤξǤ
			// ξϲΥե̾դ뤳ȤȤޤ
			if (part.isMimeType("message/*")) {
				// If part is Message, create temporary filename.
				name = "message" + index + ".eml";
			} else {
				name = "file" + index + ".tmp";
			}
		}
		return name;
	}

	/**
	 * źեեContent-Type֤ޤ
	 */
	public String getContentType(int index) throws MessagingException {
		return MailUtility.unfold(((Part)attachmentParts.get(index)).getContentType());
	}

	/**
	 * źեեΥ֤ޤ
	 */
	public int getSize(int index) throws MessagingException {
		return ((Part)attachmentParts.get(index)).getSize();
	}

	/**
	 * źեեɤ߹ॹȥ꡼֤ޤ
	 */
	public InputStream getInputStream(int index) throws MessagingException, IOException {
		return ((Part)attachmentParts.get(index)).getInputStream();
	}

	/**
	 * źեեꥹȥ꡼˽񤭽Фޤ
	 */
	public void writeTo(int index, OutputStream out) throws MessagingException, IOException {
		InputStream in = getInputStream(index);
		byte[] buf = new byte[1024];
		int len;
		while ((len = in.read(buf)) != -1) {
			out.write(buf, 0, len);
		}
	}

	public static void main(String[] args) throws Exception {
		javax.mail.internet.MimeMessage msg = new javax.mail.internet.MimeMessage(
				javax.mail.Session.getDefaultInstance(System.getProperties(), null), System.in);
		AttachmentsExtractor h = new AttachmentsExtractor();
		MultipartUtility.process(msg, h);
		for (int i = 0; i < h.getCount(); i++) {
			System.out.println("Attachment no : " + i);
			System.out.println("Filename = " + h.getFileName(i));
			System.out.println("******************");
			h.writeTo(i, System.out);
		}
	}
}