package com.ozacc.mail.impl;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

import com.ozacc.mail.Mail;

/**
 * MimeMessage󥹥󥹤륯饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: MimeMessageBuilder.java,v 1.11 2004/09/20 20:12:54 otsuka Exp $
 */
public class MimeMessageBuilder {

	private MimeMessage mimeMessage;

	private String charset = Mail.JIS_CHARSET;

	private boolean hasRecipient = false;

	/**
	 * 󥹥ȥ饯
	 * ǥեȤʸ ISO-2022-JP 󥳡ǥ󥰤˻Ѥޤ
	 * 
	 * @param mimeMessage
	 */
	public MimeMessageBuilder(MimeMessage mimeMessage) {
		this.mimeMessage = mimeMessage;
	}

	/**
	 * 󥹥ȥ饯
	 * ʸ̾Υ󥳡ǥ󥰤˻Ѥʸɤꤷޤ
	 * 
	 * @param mimeMessage
	 * @param charset 󥳡ǥ󥰤˻Ѥʸ
	 */
	public MimeMessageBuilder(MimeMessage mimeMessage, String charset) {
		this.mimeMessage = mimeMessage;
		this.charset = charset;
	}

	/**
	 * 󥹥ȥ饯ΰϤ줿MimeMessage򤽤Τޤ֤ޤ
	 * 
	 * @return MimeMessage
	 */
	public MimeMessage getMimeMessage() {
		return this.mimeMessage;
	}

	/**
	 * ꤵ줿᡼뤫MimeMessageޤ
	 * 
	 * @param mail MimeMessageΥȤʤMail
	 * @throws MessagingException
	 * @throws UnsupportedEncodingException
	 */
	public void buildMimeMessage(Mail mail) throws UnsupportedEncodingException, MessagingException {

		setTo(mail);

		setCc(mail);

		setBcc(mail);

		// λ꤬ʤ票顼
		if (!hasRecipient) {
			throw new MessagingException("λ꤬ޤToCcBccΤ줫Ĥϻꤹɬפޤ");
		}

		setFrom(mail);

		setSubject(mail);

		setReplyTo(mail);

		setXHeaders(mail);

		setImportance(mail);

		if (mail.isMultipartMail()) {

			if (!mail.isFileAttached() && mail.isHtmlMail()) { // Plain text, HTML

				if (mail.getText() != null && mail.getText().length() > 0) { // Plain text, HTML

					MimeMultipart textAndHtmlMultipart = new MimeMultipart("alternative");
					setPlainText(mail, textAndHtmlMultipart);
					setHtmlText(mail, textAndHtmlMultipart);
					this.mimeMessage.setContent(textAndHtmlMultipart);

				} else { // HTML Only ޥѡȤϻѤʤ

					setHtmlText(mail.getHtmlText(), this.mimeMessage);

				}

			} else if (mail.isFileAttached() && mail.isHtmlMail()) { // Plain text, HMTL, File

				MimeMultipart textAndHtmlMultipart = new MimeMultipart("alternative");
				setPlainText(mail, textAndHtmlMultipart);
				setHtmlText(mail, textAndHtmlMultipart);

				MimeMultipart containingMultipart = new MimeMultipart();
				MimeBodyPart textBodyPart = createMimeBodyPart(containingMultipart);
				textBodyPart.setContent(textAndHtmlMultipart);
				setAttachmentFiles(mail, containingMultipart);

				this.mimeMessage.setContent(containingMultipart);

			} else if (mail.isFileAttached() && !mail.isHtmlMail()) { // Plain text, File

				MimeMultipart textAndFileMultipart = new MimeMultipart();
				setPlainText(mail, textAndFileMultipart);
				setAttachmentFiles(mail, textAndFileMultipart);
				this.mimeMessage.setContent(textAndFileMultipart);

			} else { // Plain text only ޥѡȤϻѤʤ

				setText(mail.getText(), this.mimeMessage);

			}

		} else {

			setText(mail.getText(), this.mimeMessage);

		}

	}

	/**
	 * 
	 * @since 1.1
	 * 
	 * @param mail
	 * @param mimeMultipart
	 * @throws MessagingException
	 * @throws UnsupportedEncodingException 
	 */
	private void setAttachmentFiles(Mail mail, MimeMultipart mimeMultipart)
																			throws MessagingException,
																			UnsupportedEncodingException {
		Mail.AttachmentFile[] files = mail.getAttachmentFiles();
		for (int i = 0; i < files.length; i++) {
			MimeBodyPart bodyPart = createMimeBodyPart(mimeMultipart);
			Mail.AttachmentFile attachmentFile = files[i];
			addAttachment(attachmentFile.getName(), attachmentFile.getDataSource(), bodyPart);
		}
	}

	/**
	 * 
	 * @since 1.1
	 * 
	 * @param mail
	 * @param mimeMultipart
	 * @throws MessagingException 
	 */
	private void setHtmlText(Mail mail, MimeMultipart mimeMultipart) throws MessagingException {
		if (mail.isHtmlMail()) {
			MimeBodyPart bodyPart = createMimeBodyPart(mimeMultipart);
			setHtmlText(mail.getHtmlText(), bodyPart);
		}
	}

	/**
	 * 
	 * @since 1.1
	 * 
	 * @param mail
	 * @param mimeMultipart
	 * @throws MessagingException 
	 */
	private void setPlainText(Mail mail, MimeMultipart mimeMultipart) throws MessagingException {
		if (mail.getText() != null && mail.getText().length() > 0) {
			MimeBodyPart bodyPart = createMimeBodyPart(mimeMultipart);
			setText(mail.getText(), bodyPart);
		}
	}

	/**
	 * MimeBodyPart󥹥󥹤ꤵ줿MimeMultipartϿޤ
	 * 
	 * Υ᥽åɤϥޥѡȥ᡼ˤΤ߸ƤӽФȤǤޤ
	 * ץ졼ƥȥ᡼ˤϡmimeMulipartnullʤΤǡ
	 * NullPointerExceptionޤ
	 * 
	 * @since 1.1
	 * 
	 * @param mm
	 * @return 줿MimeBodyPart
	 * @throws MessagingException 
	 */
	private MimeBodyPart createMimeBodyPart(MimeMultipart mm) throws MessagingException {
		MimeBodyPart bodyPart = new MimeBodyPart();
		mm.addBodyPart(bodyPart);
		return bodyPart;
	}

	/**
	 * @since 1.1
	 * 
	 * @param htmlText
	 * @param mimePart 
	 * @throws MessagingException
	 */
	private void setHtmlText(final String htmlText, MimePart mimePart) throws MessagingException {
		if (charset != null) {
			mimePart.setContent(htmlText, "text/html; charset=" + charset);
		} else {
			mimePart.setContent(htmlText, "text/html");
		}
		mimePart.setHeader("Content-Transfer-Encoding", "7bit");
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setXHeaders(Mail mail) throws MessagingException {
		Map headers = mail.getXHeaders();
		if (headers == null) {
			return;
		}

		Iterator itr = headers.keySet().iterator();
		while (itr.hasNext()) {
			String key = (String)itr.next();
			String value = (String)headers.get(key);
			mimeMessage.setHeader(key, value);
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setImportance(Mail mail) throws MessagingException {
		if (mail.getImportance() != null) {
			mimeMessage.setHeader("Importance", mail.getImportance());

			int level = 3;
			if (Mail.Importance.HIGH.equals(mail.getImportance())) {
				level = 1;
			} else if (Mail.Importance.LOW.equals(mail.getImportance())) {
				level = 5;
			}
			mimeMessage.setHeader("X-Priority", String.valueOf(level));
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setReplyTo(Mail mail) throws MessagingException {
		if (mail.getReplyTo() != null) {
			mimeMessage.setReplyTo(new InternetAddress[] { mail.getReplyTo() });
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setBcc(Mail mail) throws MessagingException {
		if (mail.getBcc().length > 0) {
			mimeMessage.setRecipients(MimeMessage.RecipientType.BCC, mail.getBcc());
			hasRecipient = true;
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setCc(Mail mail) throws MessagingException {
		if (mail.getCc().length > 0) {
			mimeMessage.setRecipients(MimeMessage.RecipientType.CC, mail.getCc());
			hasRecipient = true;
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setTo(Mail mail) throws MessagingException {
		if (mail.getTo().length > 0) {
			mimeMessage.setRecipients(MimeMessage.RecipientType.TO, mail.getTo());
			hasRecipient = true;
		}
	}

	/**
	 * ʸ򥻥åȡ
	 * <p>
	 * NOTE: ʸκǸ˲ԤʤMozillaϤΥ᡼顼ǺǽԤܸ줬ʸƤޤ١
	 * message.setTextΰǺǸ\nɲäƤ롣
	 * 
	 * @since 1.1
	 * 
	 * @param text ʸ
	 * @param mimePart ʸ򥻥åȤMimePart 
	 * @throws MessagingException
	 */
	private void setText(String text, MimePart mimePart) throws MessagingException {
		if (charset != null) {
			if (charset.equalsIgnoreCase(Mail.JIS_CHARSET)) {
				// Cp932饹ѤơŪJISѴ
				mimePart.setText(Cp932.toJIS(text) + "\n", charset);
			} else {
				mimePart.setText(text + "\n", charset);
			}
		} else {
			mimePart.setText(text + "\n");
		}
		mimePart.setHeader("Content-Transfer-Encoding", "7bit");
	}

	/**
	 * @param mail
	 * @throws MessagingException
	 * @throws UnsupportedEncodingException
	 */
	private void setSubject(Mail mail) throws UnsupportedEncodingException, MessagingException {
		if (charset != null) {
			if (charset.equalsIgnoreCase(Mail.JIS_CHARSET)) {
				String subject = Cp932.toJIS(mail.getSubject());
				mimeMessage.setSubject(MimeUtility.encodeText(subject, charset, "B"));
			} else {
				mimeMessage.setSubject(mail.getSubject(), charset);
			}
		} else {
			mimeMessage.setSubject(mail.getSubject());
		}
	}

	/**
	 * @param mail
	 * @throws MessagingException 
	 */
	private void setFrom(Mail mail) throws MessagingException {
		mimeMessage.setFrom(mail.getFrom());
	}

	/**
	 * źեեǡꤵ줿MimeBodyPart˥åȤޤ
	 * 
	 * @since 1.1
	 * 
	 * @param fileName
	 * @param dataSource
	 * @param mimeBodyPart եǡ򥻥åȤMimeBodyPart
	 * @throws UnsupportedEncodingException
	 * @throws MessagingException
	 */
	private void addAttachment(String fileName, DataSource dataSource, MimeBodyPart mimeBodyPart)
																									throws UnsupportedEncodingException,
																									MessagingException {
		if (charset != null) {
			// ե̾Υ󥳡
			mimeBodyPart.setFileName(MimeUtility.encodeText(fileName, charset, "B"));
		} else {
			mimeBodyPart.setFileName(fileName);
		}

		mimeBodyPart.setDataHandler(new DataHandler(dataSource));
	}

}