/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailBuilder;
import com.ozacc.mail.impl.AbstractXMLMailBuilder;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLMailBuilderImpl
extends AbstractXMLMailBuilder
implements MailBuilder {
    public Mail buildMail(String classPath) throws MailBuildException {
        Document doc;
        try {
            doc = this.getDocumentFromClassPath(classPath);
        }
        catch (SAXException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        return this.buildMail(doc);
    }

    public Mail buildMail(File file) throws MailBuildException {
        Document doc;
        try {
            doc = this.getDocumentFromFile(file);
        }
        catch (SAXException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        return this.buildMail(doc);
    }

    protected Mail buildMail(Document doc) {
        Element root = doc.getDocumentElement();
        Mail mail = new Mail();
        this.setReturnPath(root, mail);
        this.setFrom(root, mail);
        this.setRecipients(root, mail);
        this.setReplyTo(root, mail);
        this.setSubject(root, mail);
        this.setText(root, mail);
        this.setHtml(root, mail);
        return mail;
    }
}

