package com.ozacc.blog.feed;

import java.net.URL;

/**
 * HTML内に埋め込まれたフィードのURLを自動的に見つけ出します。
 * <p>
 * HTML内にlinkタグを用いて次のフォーマットで埋め込まれています。<br>
 * <code>&lt;link href=&quot;http://www.example.com/index.rdf&quot; type=&quot;application/rss+xml&quot; rel=&quot;alternate&quot;&gt;</code>
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: FeedAutoDiscovery.java 197 2005-08-10 01:43:23Z otsuka $
 */
public interface FeedAutoDiscovery {

	/**
	 * 指定されたURLのページに埋め込まれたRSSのURLを自動的に検出します。
	 * 
	 * @param targetPageUrl 検索対象ページのURL
	 * @return 検出したRSSのURL。
	 * 1ページに複数埋め込まれている場合、全てのURLを返します。
	 * 検出できなかった場合は、空のURL配列が返されます。
	 * 
	 * @throws ParseException 指定されたURLへの接続やHTMLパースに失敗した場合
	 */
	URL[] discoverFeedUrls(URL targetPageUrl) throws ParseException;

	/**
	 * 指定されたURLのページに埋め込まれたRSSのURLを自動的に検出します。
	 * 
	 * @param targetPageUrl 検索対象ページのURL
	 * @return 検出したRSSのURL。
	 * 1ページに複数埋め込まれている場合、全てのURLを返します。
	 * 検出できなかった場合は、空のURL配列が返されます。
	 * 
	 * @throws ParseException 指定されたURLへの接続やHTMLパースに失敗した場合
	 */
	URL[] discoverFeedUrls(String targetPageUrl) throws ParseException;

}