package com.ozacc.blog.feed;

import java.net.URL;

/**
 * フィードパーサ。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: FeedParser.java 197 2005-08-10 01:43:23Z otsuka $
 */
public interface FeedParser {

	/**
	 * 指定された URL のフィード XML を解析し、Channel インスタンスを生成します。
	 * 
	 * @param feedUrl フィードのXMLファイルを示すURL
	 * @return フィードを示すChannelインスタンス
	 * @throws ParseException フィードの取得、またはパースに失敗した場合
	 */
	Channel parseFeed(URL feedUrl) throws ParseException;

	/**
	 * 指定された URL のフィード XML を解析し、Channel インスタンスを生成します。
	 * 
	 * @param feedUrl フィードのXMLファイルを示すURL
	 * @return フィードを示すChannelインスタンス
	 * @throws ParseException フィードの取得、またはパースに失敗した場合
	 */
	Channel parseFeed(String feedUrl) throws ParseException;

	/**
	 * Basic認証でアクセス制限されているURLのフィード XMLを解析し、Channel インスタンスを生成します。
	 * 
	 * @since 1.2.3
	 * 
	 * @param feedUrl 、Channel インスタンスを生成します。のXMLファイルを示すURL
	 * @param userName 認証ユーザ名
	 * @param password 認証パスワード
	 * @return 、Channel インスタンスを生成します。を示すChannelインスタンス
	 * @throws ParseException 、Channel インスタンスを生成します。の取得、またはパースに失敗した場合
	 */
	Channel parseFeed(URL feedUrl, String userName, String password) throws ParseException;

	/**
	 * Basic認証でアクセス制限されているURLのフィード XMLを解析し、Channel インスタンスを生成します。
	 * 
	 * @since 1.2.3
	 * 
	 * @param feedUrl フィードのXMLファイルを示すURL
	 * @param userName 認証ユーザ名
	 * @param password 認証パスワード
	 * @return フィードを示すChannelインスタンス
	 * @throws ParseException フィードの取得、またはパースに失敗した場合
	 */
	Channel parseFeed(String feedUrl, String userName, String password) throws ParseException;

	/**
	 * 指定されたURLのWebページに埋め込まれたフィード URLを探し出し、
	 * そのURLのフィード XMLを解析して、Channel インスタンスを生成します。<br>
	 * 複数のフィード URLが見つかった場合は、一番最初に見つかったURLの示すフィードが対象になります。
	 * 
	 * @param targetPageUrl
	 * @return Channel フィードを示すChannelインスタンス
	 * @throws ParseException フィードの取得、またはパースに失敗した場合
	 *
	 * @see FeedAutoDiscovery
	 */
	Channel discoverAndParseFeed(URL targetPageUrl) throws ParseException;

	/**
	 * 指定されたURLのWebページに埋め込まれたRSS URLを探し出し、
	 * そのURLのフィード XMLを解析して、Channel インスタンスを生成します。<br>
	 * 複数のフィード URLが見つかった場合は、一番最初に見つかったURLの示すフィードが対象になります。
	 * 
	 * @param targetPageUrl
	 * @return Channel フィードを示すChannelインスタンス
	 * @throws ParseException フィードの取得、またはパースに失敗した場合
	 *
	 * @see FeedAutoDiscovery
	 */
	Channel discoverAndParseFeed(String targetPageUrl) throws ParseException;

}