package com.ozacc.blog.feed;

import java.net.URL;

/**
 * フィード Item インターフェース。
 * <p>
 * 通常、Blogの個々のエントリーを示します。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: Item.java 197 2005-08-10 01:43:23Z otsuka $
 */
public interface Item extends DublinCoreMetadata, ContentMetadata {

	/**
	 * エントリーの要約を返します。<br>
	 * Blogツールによっては要約ではなく、全文を掲載する場合もあります。
	 * 
	 * @return エントリーの要約
	 */
	String getDescription();

	void setDescription(String description);

	/**
	 * エントリーのWebページURLを返します。
	 * 
	 * @return エントリーのWebページURL
	 */
	URL getLink();

	void setLink(URL url);

	/**
	 * エントリーのタイトルを返します。
	 * 
	 * @return エントリーのタイトル
	 */
	String getTitle();

	void setTitle(String title);

}