package com.ozacc.blog.feed.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import org.jdom.Document;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.FeedFormat;
import com.ozacc.blog.feed.FeedGenerator;

/**
 * FeedGenerator インターフェースの実装クラス。
 * 
 * @since 1.2.6
 * @author Tomohiro Otsuka
 * @version $Id: FeedGeneratorImpl.java 197 2005-08-10 01:43:23Z otsuka $
 */
public class FeedGeneratorImpl implements FeedGenerator {

	/** デフォルトの文字コード「UTF-8」。 */
	public static final String DEFAULT_CHARSET = "UTF-8";

	private String charset = DEFAULT_CHARSET;

	/**
	 * コンストラクタ。
	 */
	public FeedGeneratorImpl() {
		super();
	}

	/**
	 * 使用する文字コードをセットするコンストラクタ。
	 * 
	 * @param charset 出力ファイルに使用する文字コード
	 */
	public FeedGeneratorImpl(String charset) {
		this();
		setCharset(charset);
	}

	/**
	 * 出力ファイルに使用する文字コードをセットします。
	 * 
	 * @param charset 出力ファイルに使用する文字コード
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * RSS 1.0 と ATOM 0.3 に対応しています。
	 * 
	 * @see com.ozacc.blog.feed.FeedGenerator#write(com.ozacc.blog.feed.Channel, java.io.File, com.ozacc.blog.feed.FeedFormat)
	 */
	public void write(Channel channel, File file, FeedFormat rssVersion) throws IOException {
		String rdf = convertIntoString(channel, rssVersion);
		PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file),
				charset));
		out.print(rdf);
		out.close();
	}

	/**
	 * @see com.ozacc.blog.feed.FeedGenerator#convertIntoJDOMDocument(com.ozacc.blog.feed.Channel, com.ozacc.blog.feed.FeedFormat)
	 */
	public Document convertIntoJDOMDocument(Channel channel, FeedFormat rssVersion) {
		throw new UnsupportedOperationException();
	}

	/**
	 * RSS 1.0 と ATOM 0.3 に対応しています。
	 * 
	 * @see com.ozacc.blog.feed.FeedGenerator#convertIntoString(com.ozacc.blog.feed.Channel, com.ozacc.blog.feed.FeedFormat)
	 */
	public String convertIntoString(Channel channel, FeedFormat rssVersion) {
		if (rssVersion == FeedFormat.RSS_2_0) {
			throw new UnsupportedOperationException();
		}
		if (rssVersion == FeedFormat.ATOM_0_3) {
			return Atom_0_3_Builder.buildAtom(channel, charset);
		}
		return RSS_1_0_Builder.buildRSS(channel, charset);

	}

}