package com.ozacc.blog.feed.impl;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.Item;
import com.ozacc.blog.util.DateFormat;

/**
 * RSS 1.0のXMLを生成するクラス。
 * 
 * @since 1.2.6
 * @author Tomohiro Otsuka
 * @version $Id: RSS_1_0_Builder.java 197 2005-08-10 01:43:23Z otsuka $
 */
class RSS_1_0_Builder {

	/**
	 * 指定されたChannelインスタンスからRSS 1.0のXML文字列を生成します。
	 * 
	 * @param channel
	 * @param charset XMLに指定する文字コード
	 * @return RSS 1.0のXML文字列
	 */
	public static String buildRSS(Channel c, String charset) {
		ChannelWrapper channel = new ChannelWrapper(c);
		StringBuffer buf = new StringBuffer(1000);
		buf.append("<?xml version=\"1.0\" encoding=\"").append(charset).append("\"?>\n");
		buf.append("<rdf:RDF\n");
		buf.append("  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
		buf.append("  xmlns=\"http://purl.org/rss/1.0/\"\n");
		buf.append("  xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n");
		buf.append("  xmlns:sy=\"http://purl.org/rss/1.0/modules/syndication/\">\n");
		buf.append("\n");
		buf.append("  <channel rdf:about=\"").append(channel.getLink()).append("\">\n");
		buf.append("    <title>").append(channel.getTitle()).append("</title>\n");
		buf.append("    <link>").append(channel.getLink()).append("</link>\n");
		buf.append("    <description>").append(channel.getDescription()).append("</description>\n");
		if (channel.getLanguage() != null)
			buf.append("    <dc:language>").append(channel.getLanguage())
					.append("</dc:language>\n");
		if (channel.getCreator() != null)
			buf.append("    <dc:creator>").append(channel.getCreator()).append("</dc:creator>\n");
		if (channel.getDate() != null)
			buf.append("    <dc:date>").append(DateFormat.format(channel.getDate())).append(
					"</dc:date>\n");
		buf.append("    <items>\n");
		buf.append("      <rdf:Seq>\n");
		for (int i = 0; i < channel.getItems().length; i++) {
			Item item = channel.getItems()[i];
			buf.append("        <rdf:li rdf:resource=\"").append(item.getLink()).append("\" />\n");
		}
		buf.append("      </rdf:Seq>\n");
		buf.append("    </items>\n");
		buf.append("  </channel>\n");
		buf.append("\n");
		for (int i = 0; i < channel.getItems().length; i++) {
			Item item = channel.getItems()[i];
			buildItemElement(buf, item);
		}
		buf.append("</rdf:RDF>\n");

		return buf.toString();
	}

	/**
	 * @param buf
	 * @param item 
	 */
	private static void buildItemElement(StringBuffer buf, Item item) {
		buf.append("  <item rdf:about=\"").append(item.getLink()).append("\">\n");
		buf.append("    <title>").append(item.getTitle()).append("</title>\n");
		buf.append("    <link>").append(item.getLink()).append("</link>\n");
		buf.append("    <description>").append(item.getDescription()).append("</description>\n");
		if (item.getSubject() != null)
			buf.append("    <dc:subject>").append(item.getSubject()).append("</dc:subject>\n");
		if (item.getCreator() != null)
			buf.append("    <dc:creator>").append(item.getCreator()).append("</dc:creator>\n");
		if (item.getDate() != null)
			buf.append("    <dc:date>").append(DateFormat.format(item.getDate())).append(
					"</dc:date>\n");
		buf.append("  </item>\n");
	}

}