package com.ozacc.blog.ping.impl;

import java.net.URL;

import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpcClient;

import com.ozacc.blog.ping.UpdatePingCallbackHandler;
import com.ozacc.blog.ping.AsyncUpdatePingClient;
import com.ozacc.blog.ping.UpdatePing;
import com.ozacc.blog.ping.UpdatePingException;

/**
 * XML-RPCを用いて更新Pingを送信するAsyncUpdatePingClientインターフェースの実装クラス。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: AsyncXmlRpcUpdatePingClient.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class AsyncXmlRpcUpdatePingClient extends XmlRpcUpdatePingClient implements
		AsyncUpdatePingClient {

	/**
	 * @see com.ozacc.blog.ping.AsyncUpdatePingClient#ping(java.lang.String,
	 *        com.ozacc.blog.ping.UpdatePing, com.ozacc.blog.ping.AsyncCallbackHandler)
	 */
	public void ping(String pingUrl, UpdatePing ping, UpdatePingCallbackHandler handler) {
		AsyncCallback asyncCallback = createAsyncCallbackInstance(handler);
		XmlRpcClient client;
		try {
			client = getRpcClient(pingUrl);
		} catch (UpdatePingException e) {
			handler.handleError(e, pingUrl);
			return;
		}
		client.executeAsync(PING_METHOD_NAME, ping.getParameters(), asyncCallback);
	}

	/**
	 * @see com.ozacc.blog.ping.AsyncUpdatePingClient#ping(java.lang.String, java.lang.String,
	 *        java.lang.String, com.ozacc.blog.ping.AsyncCallbackHandler)
	 */
	public void ping(String pingUrl, String blogName, String blogUrl, UpdatePingCallbackHandler handler) {
		UpdatePing ping = new UpdatePing(blogName, blogUrl);
		ping(pingUrl, ping, handler);
	}

	/**
	 * AsyncCallbackHandler インスタンスをラップした AsyncCallback インスタンスを生成します。
	 * 
	 * @param handler
	 * @return XmlRpcClient#executeAsync() の引数に指定する AsynCallback インターフェースの実装オブジェクト
	 */
	private AsyncCallback createAsyncCallbackInstance(final UpdatePingCallbackHandler handler) {
		return new AsyncCallback() {

			public void handleResult(Object result, URL url, String method) {
				try {
					String message = processResult(result);
					handler.handleResult(message, url.toExternalForm());
				} catch (UpdatePingException ex) {
					handler.handleError(ex, url.toExternalForm());
				}
			}

			public void handleError(Exception ex, URL url, String method) {
				handler.handleError(new UpdatePingException(ex.getMessage(), ex), url
						.toExternalForm());
			}
		};
	}

	/**
	 * @see com.ozacc.blog.ping.AsyncUpdatePingClient#ping(java.lang.String[], com.ozacc.blog.ping.UpdatePing, com.ozacc.blog.ping.AsyncCallbackHandler)
	 */
	public void ping(String[] pingUrls, UpdatePing ping, UpdatePingCallbackHandler handler) {
		for (int i = 0; i < pingUrls.length; i++) {
			String url = pingUrls[i];
			ping(url, ping, handler);
		}
	}
}