package com.ozacc.blog.trackback;

import java.net.URL;

/**
 * トラックバックPingを非同期に送信するクライアントのインターフェース。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: AsyncTrackBackClient.java 180 2005-07-22 09:26:25Z otsuka $
 */
public interface AsyncTrackBackClient {

	/**
	 * 指定されたURLのサーバにトラックバックPingを非同期に送信します。
	 * 
	 * @param trackBackPingUrl サーバのURL
	 * @param ping 送信するデータ
	 * @param handler 結果を処理するイベントハンドラ
	 */
	void ping(URL trackBackPingUrl, TrackBackPing ping, TrackBackCallbackHandler handler);

	/**
	 * 指定されたURLのサーバにトラックバックPingを非同期に送信します。
	 * 
	 * @param trackBackPingUrl サーバのURL
	 * @param ping 送信するデータ
	 * @param handler 結果を処理するイベントハンドラ
	 */
	void ping(String trackBackPingUrl, TrackBackPing ping, TrackBackCallbackHandler handler);

}