package com.ozacc.blog.trackback;

import java.net.URL;

/**
 * トラックバックPingを送信するクライアントのインターフェース。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackClient.java 180 2005-07-22 09:26:25Z otsuka $
 */
public interface TrackBackClient {

	/**
	 * 指定されたURLのサーバにトラックバックPingを送信します。<br>
	 * エラーレスポンスを受けた場合にTrackBackExceptionをスローします。
	 * 
	 * @param trackBackPingUrl サーバのURL
	 * @param ping 送信するデータ
	 * @throws TrackBackException
	 */
	void ping(URL trackBackPingUrl, TrackBackPing ping) throws TrackBackException;

	/**
	 * 指定されたURLのサーバにトラックバックPingを送信します。<br>
	 * エラーレスポンスを受けた場合にTrackBackExceptionをスローします。
	 * 
	 * @param trackBackPingUrl サーバのURL
	 * @param ping 送信するデータ
	 * @throws TrackBackException
	 */
	void ping(String trackBackPingUrl, TrackBackPing ping) throws TrackBackException;

}