package com.ozacc.blog.trackback.support.impl;

import javax.servlet.http.HttpServletRequest;

import com.ozacc.blog.trackback.TrackBackPing;
import com.ozacc.blog.trackback.support.CharsetResolver;

/**
 * goo blog用のCharsetResolver。
 * <p>
 * goo blogはcharsetパラメータをセットせずにEUCでトラックバックを送信するため、
 * 文字コードの判定ができません。(2004年12月6日現在)<br>
 * そのため、urlパラメータに blog.goo.ne.jp が含まれている場合に文字コードを
 * EUCとみなします。
 * 
 * @since 1.2.3
 * @author Tomohiro Otsuka
 * @version $Id: GooBlogCharsetResolver.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class GooBlogCharsetResolver implements CharsetResolver {

	/**
	 * @see com.ozacc.blog.trackback.support.CharsetResolver#resolveCharset(com.ozacc.blog.trackback.TrackBackPing, javax.servlet.http.HttpServletRequest)
	 */
	public String resolveCharset(TrackBackPing ping, HttpServletRequest request) {
		if (ping.getUrl().indexOf("blog.goo.ne.jp") != -1) {
			return "EUC-JP";
		}
		return null;
	}

}