package com.ozacc.blog.feed.impl;

import java.io.File;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;

import junit.framework.TestCase;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.FeedFormat;
import com.ozacc.blog.feed.FeedGenerator;
import com.ozacc.blog.feed.Item;
import com.ozacc.blog.feed.impl.ChannelImpl;
import com.ozacc.blog.feed.impl.FeedGeneratorImpl;

/**
 * RSSGenerator 鐃緒申鐃粛鰹申鐃緒申鐃・Atom_0_3_Builder 鐃緒申鐃初ス鐃緒申鐃緒申僂鐃緒申鐃銃ワ申鐃夙ワ申鐃緒申鐃緒申鐃緒申
 * 
 * @author Tomohiro Otsuka
 * @version $Id: Atom_0_3_BuilderTest.java 198 2005-08-10 01:43:46Z otsuka $
 */
public class Atom_0_3_BuilderTest extends TestCase {

	private FeedGenerator gen;

	private Channel c;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		gen = new FeedGeneratorImpl();
		c = new ChannelImpl();
		c.setTitle("IBM developerWorks");
		c.setCreator("IBM developerWorks");
		c.setDescription("The latest content from IBM developerWorks");
		c.setDate(getDate(2005, 2, 9, 12, 48, 48));
		c.setLanguage("en");
		c.setLink(new URL("http://www.ibm.com/developerworks/"));

		Item i1 = c.newItem();
		i1.setTitle("Data alignment: Straighten up and fly right");
		i1
				.setDescription("Data alignment is an important issue for all programmers who directly use memory. Data alignment affects how well your software performs, and even if your software runs at all. As this article illustrates, understanding the nature of alignment can also explain some of the \"weird\" behaviors of some processors.");
		i1.setLink(new URL("http://www.ibm.com/developerworks/library/pa-dalign/index.html"));
		i1.setDate(getDate(2005, 2, 9, 12, 48, 48));

		Item i2 = c.newItem();
		i2.setTitle("AOP@Work: AOP tools comparison, Part 1");
		i2
				.setDescription("AOP is a technology whose time has come, but how do you choose the right tool for your projects? In this first article in the new \"AOP@Work\" series, aspect-oriented programming expert Mik Kersten compares the four leading AOP tools (AspectJ, AspectWerkz,\nJBoss AOP, and Spring AOP) to help you decide which one is for you. In Part 1 of this two-part discussion, Mik focuses on the tools' language mechanisms and the tradeoffs imposed by the different approaches.  Mik uses an example aspect written in each tool to give you a sense of the high-level differences between them. He also discusses the effect of each tool's syntactic approach on AOP semantics. The article concludes with an in-depth comparison of the tools' core language mechanisms, such as pointcut matching and composition, advice forms, and join\npoint context. \nNote that this article addresses the implications of the recently announced merging of the AspectJ and AspectWerkz projects.");
		i2.setLink(new URL("http://www.ibm.com/developerworks/library/j-aopwork1/index.html"));
		i2.setDate(getDate(2005, 2, 9, 12, 48, 48));

		c.addItem(i1);
		c.addItem(i2);

	}

	private Date getDate(int i, int j, int k, int l, int m, int n) {
		Calendar c = Calendar.getInstance();
		c.set(i, j, k - 1, l, m, n);
		return c.getTime();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testWrite() throws Exception {
		File dest = new File("src/test/data/index_atom.xml");
		gen.write(c, dest, FeedFormat.ATOM_0_3);
	}

}