package com.ozacc.blog.feed.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import junit.framework.TestCase;

import org.apache.commons.io.FileUtils;
import org.apache.log4j.BasicConfigurator;

import com.ozacc.blog.feed.Channel;
import com.ozacc.blog.feed.FeedFormat;
import com.ozacc.blog.feed.Item;
import com.ozacc.blog.feed.impl.ChannelImpl;
import com.ozacc.blog.feed.impl.FeedGeneratorImpl;

/**
 * RSSGeneratorImplのテストケース。
 * 
 * @since 1.2.6
 * @author Tomohiro Otsuka
 * @version $Id: FeedGeneratorImplTest.java 198 2005-08-10 01:43:46Z otsuka $
 */
public class FeedGeneratorImplTest extends TestCase {

	private FeedGeneratorImpl generator;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();
		generator = new FeedGeneratorImpl();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
		BasicConfigurator.resetConfiguration();
	}

	public final void testWriteRSS1_0() throws Exception {
		File dest = new File("target/test/data/index.rdf");
		dest.getParentFile().mkdirs();
		Channel c = getChannelForTest();
		generator.write(c, dest, FeedFormat.RSS_1_0);

		File f = new File("src/test/data/index.rdf");
		assertTrue(FileUtils.contentEquals(f, dest));
	}

	/**
	 * @throws MalformedURLException 
	 */
	private Channel getChannelForTest() throws MalformedURLException {
		Channel c = new ChannelImpl();
		c.setTitle("ozacc-blog library");
		c.setLink(new URL("http://sourceforge.jp/projects/spring-ext/"));
		c.setDescription("Spring Frameworkをメインに、その他のIoCコンテナでも使えたり使えなかったりするモジュールを提供したりしなかったり。");
		c.setLanguage("ja");
		c.setDate(getDate(2005, 1, 24, 11, 22));

		Item i1 = c.newItem();
		i1.setTitle("ozacc-mail library 1.1.3 リリース");
		i1.setLink(new URL("http://sourceforge.jp/forum/forum.php?forum_id=5795"));
		i1.setDate(getDate(2005, 1, 24, 11, 22));
		i1.setDescription("MockSendMailのバグを修正しました。");
		i1.setSubject("news");
		i1.setCreator("otsuka");
		c.addItem(i1);

		Item i2 = c.newItem();
		i2.setTitle("ozacc-mail library 1.1 リリース");
		i2.setLink(new URL("http://sourceforge.jp/forum/forum.php?forum_id=5560"));
		i2.setDate(getDate(2005, 1, 23, 21, 45));
		i2.setDescription("マルチパートメッセージ(ファイル添付やHTMLメール)の送信をサポートしたり、その他いろいろと改良しました。");
		i2.setSubject("news");
		i2.setCreator("otsuka");
		c.addItem(i2);

		Item i3 = c.newItem();
		i3.setTitle("<HTML>エスケープ");
		i3.setLink(new URL("http://sourceforge.jp/projects/spring-ext/"));
		i3.setDate(getDate(2005, 1, 22, 13, 14));
		i3.setDescription("<>\"&");
		i3.setSubject("news");
		i3.setCreator("otsuka");
		c.addItem(i3);

		return c;
	}

	private Date getDate(int year, int mon, int day, int hour, int minute) {
		Calendar cal = new GregorianCalendar(year, mon - 1, day, hour, minute);
		return cal.getTime();
	}

}