package com.ozacc.blog.ping.impl;

import org.apache.log4j.BasicConfigurator;

import junit.framework.TestCase;

import com.ozacc.blog.ping.AsyncUpdatePingClient;
import com.ozacc.blog.ping.UpdatePing;
import com.ozacc.blog.ping.UpdatePingCallbackHandler;
import com.ozacc.blog.ping.UpdatePingException;

/**
 * AsyncXmlRpcUpdatePingClientのテストケース。
 * 
 * @author Tomohiro Otsuka
 * @version $Id: AsyncUpdateClientImplTest.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class AsyncUpdateClientImplTest extends TestCase {

	AsyncUpdatePingClient client;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();
		client = new UpdatePingClientImpl();
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	/**
	 * @return
	 */
	private UpdatePingCallbackHandler getHandler() {

		return new UpdatePingCallbackHandler() {

			public void handleResult(String message, String pingUrl) {
			// do nothing
			}

			public void handleError(UpdatePingException ex, String pingUrl) {
				System.out.println("URL='" + pingUrl + "', Message='" + ex.getMessage() + "'");
			}
		};

	}

	public void testPingAsyncToWeblogsWithError() throws Exception {
		String blogName = "TestCase";
		String blogUrl = "";
		String host = "http://ping.blo.gs";
		UpdatePingCallbackHandler handler = getHandler();

		client.ping(host, blogName, blogUrl, handler);

		Thread.sleep(5 * 1000);
	}

	public void testPingAsyncToMuilpleUrlsWithError() throws Exception {
		String blogName = "TestCase";
		String blogUrl = "";
		UpdatePing ping = new UpdatePing(blogName, blogUrl);

		String[] hosts = { "http://ping.blo.gs", "http://ping.myblog.jp/" };
		UpdatePingCallbackHandler handler = getHandler();

		client.ping(hosts, ping, handler);

		Thread.sleep(5 * 1000);
	}

	/*public void testPingToBloggersReal() throws Exception {
		String blogName = "XXX Blog";
		String blogUrl = "http://blog.example.com";
		String host = "http://ping.bloggers.jp/rpc/";
		client.ping(host, blogName, blogUrl, getHandler());
		Thread.sleep(5 * 1000);
	}*/
}