package com.ozacc.blog.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import com.ozacc.blog.util.DateFormat;

import junit.framework.TestCase;

/**
 * DateFormatのテストケース。
 * 
 * @author Tomohiro Otsuka
 * @version $Id: DateFormatTest.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class DateFormatTest extends TestCase {

	public final void testFormat() throws Exception {
		String expected = "2004-08-26T15:31:49+09:00";

		Calendar c = new GregorianCalendar();
		c.set(2004, 7, 26, 15, 31, 49);
		Date d = c.getTime();

		String result = DateFormat.format(d);
		assertEquals(result, expected, result);
	}

}