/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.ping.impl;

import com.ozacc.blog.ping.AsyncUpdatePingClient;
import com.ozacc.blog.ping.ConnectionException;
import com.ozacc.blog.ping.FailedUpdatePingException;
import com.ozacc.blog.ping.UpdatePing;
import com.ozacc.blog.ping.UpdatePingCallbackHandler;
import com.ozacc.blog.ping.UpdatePingClient;
import com.ozacc.blog.ping.UpdatePingException;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdatePingClientImpl
implements UpdatePingClient,
AsyncUpdatePingClient {
    public static String PING_METHOD_NAME = "weblogUpdates.ping";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    public static final String DEFAULT_USER_AGENT = "ozacc-blog library";
    private static Log log;
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    private String userAgent = "ozacc-blog library";
    private Pattern p = Pattern.compile("<member><name>flerror</name><value><boolean>(\\d)</boolean></value></member><member><name>message</name><value><string>(.+?)</string></value></member>", 2);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.blog.ping.impl.UpdatePingClientImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String ping(String pingUrl, String blogName, String blogUrl) throws UpdatePingException {
        log.debug((Object)("\u66f4\u65b0Ping\u3092\u9001\u4fe1\u3057\u307e\u3059\u3002[pingUrl='" + pingUrl + "', blogName='" + blogName + "', blogUrl='" + blogUrl + "']"));
        HttpClient client = new HttpClient();
        log.debug((Object)("\u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.connectionTimeout + "]"));
        client.setConnectionTimeout(this.connectionTimeout);
        log.debug((Object)("\u8aad\u8fbc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.readTimeout + "]"));
        client.setTimeout(this.readTimeout);
        PostMethod method = new PostMethod(pingUrl);
        method.addRequestHeader("Content-Type", "text/xml; charset=UTF-8");
        method.addRequestHeader("User-Agent", this.userAgent);
        method.setRequestBody(this.createRequestBody(blogName, blogUrl));
        try {
            client.executeMethod((HttpMethod)method);
            String response = method.getResponseBodyAsString();
            String string = this.parseResponse(response);
            return string;
        }
        catch (HttpException e) {
            throw new UpdatePingException("\u30b5\u30fc\u30d0\u304c\u30a8\u30e9\u30fc\u3092\u8fd4\u3057\u307e\u3057\u305f\u3002", e);
            catch (IOException e2) {
                throw new ConnectionException("\u30b5\u30fc\u30d0\u3068\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30b5\u30fc\u30d0\u306eURL\u304c\u6b63\u3057\u3044\u304b\u3001\u307e\u305f\u30b5\u30fc\u30d0\u304cRPC\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002", e2);
            }
        }
        finally {
            log.debug((Object)"HTTP\u63a5\u7d9a\u3092\u9589\u3058\u307e\u3059\u3002");
            method.releaseConnection();
        }
    }

    private String parseResponse(String response) {
        log.debug((Object)("\u66f4\u65b0Ping\u30ec\u30b9\u30dd\u30f3\u30b9\n" + response));
        response = response.replaceAll("[\r\n]", "");
        Matcher m = this.p.matcher(response);
        if (m.find()) {
            String flag = m.group(1);
            String message = m.group(2);
            if ("0".equals(flag)) {
                return message;
            }
            throw new FailedUpdatePingException(message);
        }
        throw new UpdatePingException("\u30b5\u30fc\u30d0\u304c\u30a8\u30e9\u30fc\u3092\u8fd4\u3057\u307e\u3057\u305f\u3002");
    }

    private String createRequestBody(String blogName, String blogUrl) {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append("<methodCall>");
        buf.append("<methodName>").append(PING_METHOD_NAME).append("</methodName>");
        buf.append("<params>");
        buf.append("<param><value>").append(blogName).append("</value></param>");
        buf.append("<param><value>").append(blogUrl).append("</value></param>");
        buf.append("</params>");
        buf.append("</methodCall>");
        return buf.toString();
    }

    public String ping(String pingUrl, UpdatePing ping) throws UpdatePingException {
        Vector v = ping.getParameters();
        return this.ping(pingUrl, (String)v.get(0), (String)v.get(1));
    }

    public void ping(String pingUrl, UpdatePing ping, UpdatePingCallbackHandler handler) {
        Vector v = ping.getParameters();
        this.ping(pingUrl, (String)v.get(0), (String)v.get(1), handler);
    }

    public void ping(String[] pingUrls, UpdatePing ping, UpdatePingCallbackHandler handler) {
        int i = 0;
        while (i < pingUrls.length) {
            String pingUrl = pingUrls[i];
            this.ping(pingUrl, ping, handler);
            ++i;
        }
    }

    public void ping(final String pingUrl, final String blogName, final String blogUrl, final UpdatePingCallbackHandler handler) {
        Thread t = new Thread(){

            public void run() {
                try {
                    String message = UpdatePingClientImpl.this.ping(pingUrl, blogName, blogUrl);
                    handler.handleResult(message, pingUrl);
                }
                catch (UpdatePingException e) {
                    handler.handleError(e, pingUrl);
                }
            }
        };
        t.start();
    }
}

