/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.trackback.impl;

import com.ozacc.blog.trackback.ConnectionException;
import com.ozacc.blog.trackback.ConnectionTimeoutException;
import com.ozacc.blog.trackback.FailedTrackBackException;
import com.ozacc.blog.trackback.TrackBackClient;
import com.ozacc.blog.trackback.TrackBackException;
import com.ozacc.blog.trackback.TrackBackPing;
import com.ozacc.blog.trackback.TrackBackResponseException;
import com.ozacc.blog.util.CommonsHttpClientUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TrackBackClientImpl
implements TrackBackClient {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    public static final String DEFAULT_CHARSET = "utf-8";
    private static Log log;
    private String userAgent;
    private String charset = "utf-8";
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.blog.trackback.impl.TrackBackClientImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public TrackBackClientImpl() {
    }

    public TrackBackClientImpl(String userAgent) {
        this.setUserAgent(userAgent);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void ping(URL trackBackPingUrl, TrackBackPing ping) throws TrackBackException {
        this.ping(trackBackPingUrl.toString(), ping);
    }

    public void ping(String trackBackPingUrl, TrackBackPing ping) throws TrackBackException {
        HttpClient client = new HttpClient();
        log.debug((Object)("\u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.connectionTimeout + "]"));
        client.setConnectionTimeout(this.connectionTimeout);
        log.debug((Object)("\u8aad\u8fbc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.readTimeout + "]"));
        client.setTimeout(this.readTimeout);
        String appliedCharset = null;
        appliedCharset = ping.getCharset() != null && ping.getCharset().length() > 0 ? ping.getCharset() : this.charset;
        PostMethod post = new PostMethod(trackBackPingUrl);
        NameValuePair[] data = this.buildPostData(ping);
        post.setRequestBody(data);
        post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + appliedCharset);
        if (this.userAgent != null) {
            post.setRequestHeader("User-Agent", this.userAgent);
        }
        try {
            try {
                int statusCode = client.executeMethod((HttpMethod)post);
                if (!CommonsHttpClientUtils.isSuccessfulResponse(statusCode, false)) {
                    throw new ConnectionException("\u6307\u5b9a\u3055\u308c\u305fTrackBack URL\u306bHTTP\u63a5\u7d9a\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[HTTP_STATUS='" + HttpStatus.getStatusText((int)statusCode) + "', TrackBackURL='" + trackBackPingUrl + "']");
                }
                InputStream is = post.getResponseBodyAsStream();
                String message = this.parseResponseStream(is);
                if (message != null) {
                    throw new FailedTrackBackException(message);
                }
                is.close();
            }
            catch (HttpConnection.ConnectionTimeoutException e) {
                throw new ConnectionTimeoutException("HTTP\u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3002[TrackBackURL='" + trackBackPingUrl + "']", e);
            }
            catch (HttpRecoverableException e) {
                throw new ConnectionTimeoutException("HTTP\u8aad\u8fbc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3002[TrackBackURL='" + trackBackPingUrl + "']", e);
            }
            catch (IOException e) {
                throw new ConnectionException("\u30c8\u30e9\u30c3\u30af\u30d0\u30c3\u30af\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[TrackBackURL='" + trackBackPingUrl + "']", e);
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    private NameValuePair[] buildPostData(TrackBackPing ping) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (this.charset != null && this.charset.length() > 0) {
            list.add(new NameValuePair("charset", this.charset.toLowerCase()));
        }
        if (ping.getTitle() != null) {
            list.add(new NameValuePair("title", ping.getTitle()));
        }
        if (ping.getUrl() != null) {
            list.add(new NameValuePair("url", ping.getUrl()));
        }
        if (ping.getExcerpt() != null) {
            list.add(new NameValuePair("excerpt", ping.getExcerpt()));
        }
        if (ping.getBlogName() != null) {
            list.add(new NameValuePair("blog_name", ping.getBlogName()));
        }
        return list.toArray(new NameValuePair[list.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private String parseResponseStream(InputStream is) throws TrackBackResponseException {
        try {
            String message;
            void var3_4;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            Document doc = factory.newDocumentBuilder().parse(is);
            NodeList errorList = doc.getElementsByTagName("error");
            Node errorNode = errorList.item(0);
            String errorCode = errorNode.getFirstChild().getNodeValue();
            if ("0".equals(errorCode)) {
                String string = null;
                return string;
            }
            NodeList msgList = var3_4.getElementsByTagName("message");
            Node msgNode = msgList.item(0);
            String string = message = msgNode.getFirstChild().getNodeValue();
            return string;
        }
        catch (Exception ex) {
            throw new TrackBackResponseException("\u30b5\u30fc\u30d0\u30ec\u30b9\u30dd\u30f3\u30b9\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        {
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }
}

