/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generator;

import java.util.Map;
import org.sql.column.JoinColumn;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.AbstractSql;
import org.sql.generator.GroupBy;
import org.sql.generator.OrderBy;
import org.sql.message.Message;
import org.sql.table.SimpleTable;
import org.sql.table.Table;
import org.sql.type.Group;
import org.sql.type.Order;

public class JoinSql
extends AbstractSql
implements OrderBy,
GroupBy {
    private JoinColumn column = null;
    private StringBuffer order = new StringBuffer();
    private Group group = null;
    private Table table = null;

    public JoinSql() {
    }

    public JoinSql(JoinColumn column) {
        this();
        this.addColumn(column);
    }

    public JoinSql(JoinColumn column, Table table) {
        this(column);
        this.addFrom(table);
    }

    public void addColumn(JoinColumn column) {
        this.column = column;
    }

    public void addFrom(Table table) {
        this.table = table;
    }

    public String getSql() throws GeneratorException {
        StringBuffer result = new StringBuffer();
        if (this.condition == null) {
            super.setCondition(new Condition());
        }
        if (this.table == null) {
            throw new GeneratorException(Message.getInstance("SQL-005"));
        }
        result.append("SELECT ");
        result.append(this.replaceColumn(this.column.toColumnString()));
        result.append(" FROM ");
        if (this.table instanceof SimpleTable) {
            result.append(this.table.toTableString());
            result.append(this.createWhere());
        } else {
            result.append(this.table.toTableString());
        }
        if (this.group != null) {
            result.append(" GROUP BY " + this.group.toTypeString());
        }
        result.append(this.createOrder());
        return result.toString();
    }

    public void addOrder(Order order) {
        if (this.order.length() == 0) {
            this.order.append(" ORDER BY ");
        } else {
            this.order.append(",");
        }
        this.order.append(order.toTypeString());
    }

    public void addOrder(Order[] orders) {
        for (int i = 0; i < orders.length; ++i) {
            this.addOrder(orders[i]);
        }
    }

    public void addGroup(Group group) {
        this.group = group;
    }

    public void clear() {
        this.condition = null;
        this.column.clear();
        this.order.delete(0, this.order.toString().length());
        this.group = null;
        this.table = null;
    }

    private String replaceColumn(String column) {
        Map map = this.table.getTableMap();
        Object[] table = map.keySet().toArray();
        String result = column;
        for (int i = 0; i < table.length; ++i) {
            result = result.replaceAll((String)table[i], (String)map.get(table[i]));
        }
        return result;
    }

    private String createWhere() throws GeneratorException {
        return this.replaceAlias(this.condition.getCondition());
    }

    private String createOrder() {
        return this.replaceAlias(this.order.toString());
    }

    private String replaceAlias(String arg) {
        String result = arg;
        if (result == null || result.length() == 0) {
            return result;
        }
        Map map = this.table.getTableMap();
        Object[] key = map.keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            result = result.replaceAll((String)key[i], (String)map.get(key[i]));
        }
        return result;
    }
}

