/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generator;

import org.sql.column.Column;
import org.sql.column.SelectColumn;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.AbstarctSimpleSql;
import org.sql.generator.GroupBy;
import org.sql.generator.OrderBy;
import org.sql.message.Message;
import org.sql.type.Group;
import org.sql.type.Lock;
import org.sql.type.Order;
import org.sql.util.GeneratorUtil;

public class SelectSql
extends AbstarctSimpleSql
implements OrderBy,
GroupBy {
    private StringBuffer order = new StringBuffer();
    private String lockString = "";
    private Column column = null;
    private Group group = null;
    private boolean distinct = false;

    public SelectSql(String table) {
        super(table);
    }

    public SelectSql(String table, SelectColumn column) {
        super(table);
        this.setColumn(column);
    }

    public SelectSql(String table, boolean distinct) {
        this(table);
        this.distinct = distinct;
    }

    public SelectSql(String table, SelectColumn column, boolean distinct) {
        this(table, column);
        this.distinct = distinct;
    }

    public void setColumn(SelectColumn column) {
        this.column = column;
    }

    public String getSql() throws GeneratorException {
        StringBuffer result = new StringBuffer();
        if (this.condition == null) {
            super.setCondition(new Condition());
        }
        if (!GeneratorUtil.isNaming(this.getFrom())) {
            throw new GeneratorException(Message.getInstance("SQL-001", this.getFrom()));
        }
        result.append("SELECT ");
        if (this.distinct) {
            result.append("DISTINCT ");
        }
        if (this.column == null) {
            this.column = new SelectColumn();
        }
        result.append(this.column.toColumnString());
        result.append(" FROM " + this.getFrom());
        result.append(this.condition.getCondition());
        result.append(this.lockString);
        if (this.group != null) {
            result.append(" GROUP BY " + this.group.toTypeString());
        }
        if (this.order.length() > 0) {
            result.append(" ORDER BY " + this.order.toString());
        }
        return result.toString();
    }

    public void addOrder(Order order) {
        if (this.order.length() > 0) {
            this.order.append(",");
        }
        this.order.append(order.toTypeString());
    }

    public void addOrder(Order[] orders) {
        for (int i = 0; i < orders.length; ++i) {
            this.addOrder(orders[i]);
        }
    }

    public void lock(Lock lockmode) {
        this.lockString = " " + lockmode.toTypeString();
    }

    public Column getColumn() {
        return this.column;
    }

    public void clear() {
        this.clearFrom();
        super.getCondition().clear();
        this.column.clear();
        this.order.delete(0, this.order.length());
        this.lockString = "";
    }

    public void addGroup(Group group) {
        this.group = group;
    }
}

