/*
 * Decompiled with CFR 0.152.
 */
package org.sql.comparison;

import java.util.Date;
import org.sql.comparison.AbstractComparison;
import org.sql.exception.FormatException;
import org.sql.type.Format;
import org.sql.type.Match;
import org.sql.util.GeneratorUtil;

public class SimpleComparison
extends AbstractComparison {
    private String property = null;

    protected SimpleComparison() {
    }

    public SimpleComparison(String column, Object value, Match match) {
        this.setProperty(match.toTypeString());
        this.createComparison(column, value);
    }

    public SimpleComparison(String column, Date value, Format format, Match match) {
        this.setProperty(match.toTypeString());
        this.createComparison(column, value, format);
    }

    protected void createComparison(String column, Object value) {
        if (value instanceof Date) {
            this.createComparison(column, (Date)value, Format.YMD_HMS);
        } else {
            super.setComparison(column + this.property + GeneratorUtil.toExclusionString(value));
        }
    }

    protected void createComparison(String column, Date value, Format format) {
        try {
            super.setComparison(column + this.property + this.toDate(value, format));
        }
        catch (FormatException e) {
            super.setException(e);
        }
    }

    protected final void setProperty(String property) {
        this.property = property;
    }
}

