/*
 * Decompiled with CFR 0.152.
 */
package org.sql.comparison;

import java.util.Date;
import org.sql.comparison.AbstractBindComparison;
import org.sql.exception.ComparisonException;
import org.sql.exception.FormatException;
import org.sql.item.DefaultItem;
import org.sql.type.Format;
import org.sql.type.Match;
import org.sql.util.GeneratorUtil;

public class SimpleComparison
extends AbstractBindComparison {
    private String property = null;
    private Format format = null;

    protected SimpleComparison() {
    }

    public SimpleComparison(String column, Object value, Match match) {
        this.setProperty(match.toTypeString());
        this.createComparison(column, value);
    }

    public SimpleComparison(String column, Date value, Format format, Match match) {
        this.setProperty(match.toTypeString());
        this.createComparison(column, value, format);
    }

    protected void createComparison(String column, Object value) {
        if (value instanceof Date) {
            this.createComparison(column, (Date)value, Format.YMD_HMS);
        } else {
            DefaultItem item = new DefaultItem();
            item.put(column, value);
            super.setComparison(item);
        }
    }

    protected void createComparison(String column, Date value, Format format) {
        DefaultItem item = new DefaultItem();
        item.put(column, value);
        super.setComparison(item);
        this.format = format;
    }

    protected final void setProperty(String property) {
        this.property = property;
    }

    protected String createComparison(DefaultItem item) throws ComparisonException {
        StringBuffer sb = new StringBuffer();
        sb.append(item.getColumn());
        sb.append(this.property);
        Object object = item.getValue()[0];
        if (object instanceof Date) {
            sb.append(GeneratorUtil.toExclusionString(this.toDate((Date)object)));
        } else {
            sb.append(GeneratorUtil.toExclusionString(object));
        }
        return sb.toString();
    }

    protected String createBindComparison(DefaultItem item) throws ComparisonException {
        StringBuffer sb = new StringBuffer();
        sb.append(item.getColumn());
        sb.append(this.property);
        if (GeneratorUtil.isExclusion(item.getValue()[0].toString())) {
            sb.append(GeneratorUtil.toExclusionString(item.getValue()[0]));
        } else {
            sb.append("?");
        }
        return sb.toString();
    }

    private String toDate(Date date) {
        String result = null;
        try {
            result = super.toDate(date, this.format);
        }
        catch (FormatException e) {
            super.setException(e);
        }
        return result;
    }
}

