/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generator;

import java.util.ArrayList;
import java.util.Arrays;
import org.sql.exception.GeneratorException;
import org.sql.generator.AbstractSql;
import org.sql.generator.OrderBy;
import org.sql.generator.Sql;
import org.sql.type.Order;

public class UnionSql
extends AbstractSql
implements OrderBy {
    private boolean unionMode = false;
    private Sql[] sql = null;
    private StringBuffer order = new StringBuffer();

    public void union(Sql[] sql) {
        this.union(sql, false);
    }

    public void unionAll(Sql[] sql) {
        this.union(sql, true);
    }

    public void addOrder(Order order) {
        if (this.order.length() == 0) {
            this.order.append(" ORDER BY ");
        } else {
            this.order.append(",");
        }
        this.order.append(order.toTypeString());
    }

    public void addOrder(Order[] orders) {
        for (int i = 0; i < orders.length; ++i) {
            this.addOrder(orders[i]);
        }
    }

    public void clear() {
        this.sql = null;
        this.order = null;
    }

    public Object[] getParameter() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.sql.length; ++i) {
            result.addAll(Arrays.asList(this.sql[i].getParameter()));
        }
        return result.toArray();
    }

    protected String createSql(boolean bind) throws GeneratorException {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.sql.length; ++i) {
            if (result.toString().length() > 0) {
                result.append(this.unionMode ? " UNION ALL " : " UNION ");
            }
            result.append(this.sql[i].getSql());
        }
        result.append(this.order.toString());
        return result.toString();
    }

    private void union(Sql[] sql, boolean unionMode) {
        this.sql = sql;
        this.unionMode = unionMode;
    }
}

